#ifdef USE_GETLINE
#define _WITH_GETLINE /* for FreeBSD */
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "readline.h"

#ifdef USE_GETLINE
char *nlsh_readline(const char *prompt)
{
  char *buffer;
  int size;
  size_t buffer_size = 0;

  fputs(prompt, stdout);
  buffer = NULL;
  size = getline(&buffer, &buffer_size, stdin);
  if (size < 0)
    return NULL;

  return buffer;
}
#endif

#ifdef USE_FGETS
char *nlsh_readline(const char *prompt)
{
  char *buffer;
  int len;
#define LINE_BUFFER_SIZE 1024

  fputs(prompt, stdout);
  buffer = malloc(LINE_BUFFER_SIZE);
  if (buffer) {
    if (fgets(buffer, LINE_BUFFER_SIZE, stdin) == NULL) {
      free(buffer);
      return NULL;
    }

    len = strlen(buffer);
    if ((len > 0) && (buffer[len - 1] == '\n'))
      buffer[len - 1] = '\0';
  }

  return buffer;
}
#endif

void nlsh_add_history(const char *line)
{
  return;
}
