#if defined(__linux__)
#if defined(__i386__)

/*
 * Use Linux system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4       114
#define SYS_kill         37
#define SYS_execve       11

#define SYS_read          3
#define SYS_write         4
#define SYS_open          5
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         63
#define SYS_pipe2       331

#define SYS_sigaction    67 /* rt_sigaction is 174 */
#define SYS_sigprocmask 126 /* rt_sigprocmask is 175 */
#define SYS_sigreturn   119 /* rt_sigreturn is 173 */

#define SYS_getpid       20
#define SYS_getppid      64
#define SYS_getsid      147
#define SYS_setsid       66
#define SYS_getpgid     132
#define SYS_setpgid      57
#define SYS_getpgrp      65

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir      133
#define SYS_chmod        15
#define SYS_chown       182
#define SYS_lseek        19
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl        55
#define SYS_fsync       118
#define SYS_fchown       95
#define SYS_fchmod       94
#define SYS_rename       38

#define SYS_mkdir        39
#define SYS_rmdir        40

#define SYS_mmap         90
#define SYS_munmap       91

#define SYS_truncate     92
#define SYS_ftruncate    93

#define SYS_select      142 /* newselect */
#define SYS_pselect     308

#define SYS_gettimeofday 78
#define SYS_settimeofday 79

#define SYS_ioctl        54
#define SYS_brk          45
#define SYS_getdents    141
#define SYS_getcwd      183

	.section .text

	.globl	___exit
	.type	___exit, @function
___exit:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_exit, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__fork
	.type	__fork, @function
__fork:
	push	%ebx
	mov	$SYS_fork, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__wait4
	.type	__wait4, @function
__wait4:
	push	%ebx
	push	%esi
	mov	0x18(%esp), %esi
	mov	0x14(%esp), %edx
	mov	0x10(%esp), %ecx
	mov	0xc(%esp), %ebx
	mov	$SYS_wait4, %eax
	int	$0x80
	pop	%esi
	pop	%ebx
	ret

	.globl	__kill
	.type	__kill, @function
__kill:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_kill, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__execve
	.type	__execve, @function
__execve:
	push	%ebx
	mov	0x10(%esp), %edx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_execve, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__read
	.type	__read, @function
__read:
	push	%ebx
	mov	0x10(%esp), %edx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_read, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__write
	.type	__write, @function
__write:
	push	%ebx
	mov	0x10(%esp), %edx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_write, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__open
	.type	__open, @function
__open:
	push	%ebx
	mov	0x10(%esp), %edx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_open, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__close
	.type	__close, @function
__close:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_close, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__dup
	.type	__dup, @function
__dup:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_dup, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__pipe
	.type	__pipe, @function
__pipe:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_pipe, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__dup2
	.type	__dup2, @function
__dup2:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_dup2, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__pipe2
	.type	__pipe2, @function
__pipe2:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_pipe2, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__sigaction
	.type	__sigaction, @function
__sigaction:
	push	%ebx
	push	%esi
	mov	0x18(%esp), %esi /* for rt_sigaction (4th argument) */
	mov	0x14(%esp), %edx
	mov	0x10(%esp), %ecx
	mov	0xc(%esp), %ebx
	mov	$SYS_sigaction, %eax
	int	$0x80
	pop	%esi
	pop	%ebx
	ret

	.globl	__sigprocmask
	.type	__sigprocmask, @function
__sigprocmask:
	push	%ebx
	mov	0x10(%esp), %edx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_sigprocmask, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__sigreturn
	.type	__sigreturn, @function
__sigreturn:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_sigreturn, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__getpid
	.type	__getpid, @function
__getpid:
	push	%ebx
	mov	$SYS_getpid, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__getppid
	.type	__getppid, @function
__getppid:
	push	%ebx
	mov	$SYS_getppid, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__getsid
	.type	__getsid, @function
__getsid:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_getsid, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__setsid
	.type	__setsid, @function
__setsid:
	push	%ebx
	mov	$SYS_setsid, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__getpgid
	.type	__getpgid, @function
__getpgid:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_getpgid, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__setpgid
	.type	__setpgid, @function
__setpgid:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_setpgid, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__getpgrp
	.type	__getpgrp, @function
__getpgrp:
	push	%ebx
	mov	$SYS_getpgrp, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__unlink
	.type	__unlink, @function
__unlink:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_unlink, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__chdir
	.type	__chdir, @function
__chdir:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_chdir, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__fchdir
	.type	__fchdir, @function
__fchdir:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_fchdir, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__chmod
	.type	__chmod, @function
__chmod:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_chmod, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__chown
	.type	__chown, @function
__chown:
	push	%ebx
	mov	0x10(%esp), %edx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_chown, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__lseek
	.type	__lseek, @function
__lseek:
	push	%ebx
	mov	0x10(%esp), %edx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_lseek, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__access
	.type	__access, @function
__access:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_access, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__sync
	.type	__sync, @function
__sync:
	push	%ebx
	mov	$SYS_sync, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__fcntl
	.type	__fcntl, @function
__fcntl:
	push	%ebx
	mov	0x10(%esp), %edx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_fcntl, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__fsync
	.type	__fsync, @function
__fsync:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_fsync, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__fchown
	.type	__fchown, @function
__fchown:
	push	%ebx
	mov	0x10(%esp), %edx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_fchown, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__fchmod
	.type	__fchmod, @function
__fchmod:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_fchmod, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__rename
	.type	__rename, @function
__rename:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_rename, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__mkdir
	.type	__mkdir, @function
__mkdir:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_mkdir, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__rmdir
	.type	__rmdir, @function
__rmdir:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_rmdir, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__mmap
	.type	__mmap, @function
__mmap:
	push	%ebx
	push	%esi
	push	%edi
	push	%ebp
	mov	0x28(%esp), %ebp
	mov	0x24(%esp), %edi
	mov	0x20(%esp), %esi
	mov	0x1c(%esp), %edx
	mov	0x18(%esp), %ecx
	mov	0x14(%esp), %ebx
	mov	$SYS_mmap, %eax
	int	$0x80
	pop	%ebp
	pop	%edi
	pop	%esi
	pop	%ebx
	ret

	.globl	__munmap
	.type	__munmap, @function
__munmap:
	push	%ebx
	push	%esi
	push	%edi
	push	%ebp
	mov	0x28(%esp), %ebp
	mov	0x24(%esp), %edi
	mov	0x20(%esp), %esi
	mov	0x1c(%esp), %edx
	mov	0x18(%esp), %ecx
	mov	0x14(%esp), %ebx
	mov	$SYS_munmap, %eax
	int	$0x80
	pop	%ebp
	pop	%edi
	pop	%esi
	pop	%ebx
	ret

	.globl	__truncate
	.type	__truncate, @function
__truncate:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_truncate, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__ftruncate
	.type	__ftruncate, @function
__ftruncate:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_ftruncate, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__select
	.type	__select, @function
__select:
	push	%ebx
	push	%esi
	push	%edi
	mov	0x20(%esp), %edi
	mov	0x1c(%esp), %esi
	mov	0x18(%esp), %edx
	mov	0x14(%esp), %ecx
	mov	0x10(%esp), %ebx
	mov	$SYS_select, %eax
	int	$0x80
	pop	%edi
	pop	%esi
	pop	%ebx
	ret

	.globl	__pselect
	.type	__pselect, @function
__pselect:
	push	%ebx
	push	%esi
	push	%edi
	push	%ebp
	mov	0x28(%esp), %ebp
	mov	0x24(%esp), %edi
	mov	0x20(%esp), %esi
	mov	0x1c(%esp), %edx
	mov	0x18(%esp), %ecx
	mov	0x14(%esp), %ebx
	mov	$SYS_pselect, %eax
	int	$0x80
	pop	%ebp
	pop	%edi
	pop	%esi
	pop	%ebx
	ret

	.globl	__gettimeofday
	.type	__gettimeofday, @function
__gettimeofday:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_gettimeofday, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__settimeofday
	.type	__settimeofday, @function
__settimeofday:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_settimeofday, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__ioctl
	.type	__ioctl, @function
__ioctl:
	push	%ebx
	mov	0x10(%esp), %edx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_ioctl, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__brk
	.type	__brk, @function
__brk:
	push	%ebx
	mov	0x8(%esp), %ebx
	mov	$SYS_brk, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	__getdents
	.type	__getdents, @function
__getdents:
	push	%ebx
	mov	0x10(%esp), %edx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_getdents, %eax
	int	$0x80
	pop	%ebx
	ret

	.globl	____getcwd
	.type	____getcwd, @function
____getcwd:
	push	%ebx
	mov	0xc(%esp), %ecx
	mov	0x8(%esp), %ebx
	mov	$SYS_getcwd, %eax
	int	$0x80
	pop	%ebx
	ret
#endif
#endif
