#if defined(__linux__)
#if defined(__aarch64__)

/*
 * Use Linux system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4       114
#define SYS_kill         37
#define SYS_execve       11

#define SYS_read          3
#define SYS_write         4
#define SYS_open          5
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         63
#define SYS_pipe2       359

#define SYS_sigaction    67 /* rt_sigaction is 174 */
#define SYS_sigprocmask 126 /* rt_sigprocmask is 175 */
#define SYS_sigreturn   119 /* rt_sigreturn is 173 */

#define SYS_getpid       20
#define SYS_getppid      64
#define SYS_getsid      147
#define SYS_setsid       66
#define SYS_getpgid     132
#define SYS_setpgid      57
#define SYS_getpgrp      65

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir      133
#define SYS_chmod        15
#define SYS_chown       182
#define SYS_lseek        19
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl        55
#define SYS_fsync       118
#define SYS_fchown       95
#define SYS_fchmod       94
#define SYS_rename       38

#define SYS_mkdir        39
#define SYS_rmdir        40

#define SYS_mmap         90
#define SYS_munmap       91

#define SYS_truncate     92
#define SYS_ftruncate    93

#define SYS_select      142 /* newselect */
#define SYS_pselect     335

#define SYS_gettimeofday 78
#define SYS_settimeofday 79

#define SYS_ioctl        54
#define SYS_brk          45
#define SYS_getdents    141
#define SYS_getcwd      183

	.section .text

	.globl	___exit
	.type	___exit, %function
___exit:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_exit
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__fork
	.type	__fork, %function
__fork:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_fork
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__wait4
	.type	__wait4, %function
__wait4:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_wait4
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__kill
	.type	__kill, %function
__kill:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_kill
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__execve
	.type	__execve, %function
__execve:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_execve
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__read
	.type	__read, %function
__read:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_read
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__write
	.type	__write, %function
__write:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_write
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__open
	.type	__open, %function
__open:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_open
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__close
	.type	__close, %function
__close:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_close
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__dup
	.type	__dup, %function
__dup:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_dup
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__pipe
	.type	__pipe, %function
__pipe:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_pipe
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__dup2
	.type	__dup2, %function
__dup2:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_dup2
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__pipe2
	.type	__pipe2, %function
__pipe2:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_pipe2
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__sigaction
	.type	__sigaction, %function
__sigaction:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_sigaction
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__sigprocmask
	.type	__sigprocmask, %function
__sigprocmask:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_sigprocmask
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__sigreturn
	.type	__sigreturn, %function
__sigreturn:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_sigreturn
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__getpid
	.type	__getpid, %function
__getpid:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_getpid
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__getppid
	.type	__getppid, %function
__getppid:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_getppid
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__getsid
	.type	__getsid, %function
__getsid:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_getsid
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__setsid
	.type	__setsid, %function
__setsid:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_setsid
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__getpgid
	.type	__getpgid, %function
__getpgid:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_getpgid
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__setpgid
	.type	__setpgid, %function
__setpgid:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_setpgid
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__getpgrp
	.type	__getpgrp, %function
__getpgrp:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_getpgrp
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__unlink
	.type	__unlink, %function
__unlink:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_unlink
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__chdir
	.type	__chdir, %function
__chdir:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_chdir
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__fchdir
	.type	__fchdir, %function
__fchdir:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_fchdir
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__chmod
	.type	__chmod, %function
__chmod:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_chmod
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__chown
	.type	__chown, %function
__chown:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_chown
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__lseek
	.type	__lseek, %function
__lseek:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_lseek
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__access
	.type	__access, %function
__access:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_access
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__sync
	.type	__sync, %function
__sync:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_sync
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__fcntl
	.type	__fcntl, %function
__fcntl:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_fcntl
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__fsync
	.type	__fsync, %function
__fsync:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_fsync
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__fchown
	.type	__fchown, %function
__fchown:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_fchown
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__fchmod
	.type	__fchmod, %function
__fchmod:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_fchmod
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__rename
	.type	__rename, %function
__rename:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_rename
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__mkdir
	.type	__mkdir, %function
__mkdir:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_mkdir
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__rmdir
	.type	__rmdir, %function
__rmdir:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_rmdir
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__mmap
	.type	__mmap, %function
__mmap:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_mmap
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__munmap
	.type	__munmap, %function
__munmap:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_munmap
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__truncate
	.type	__truncate, %function
__truncate:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_truncate
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__ftruncate
	.type	__ftruncate, %function
__ftruncate:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_ftruncate
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__select
	.type	__select, %function
__select:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_select
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__pselect
	.type	__pselect, %function
__pselect:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_pselect
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__gettimeofday
	.type	__gettimeofday, %function
__gettimeofday:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_gettimeofday
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__settimeofday
	.type	__settimeofday, %function
__settimeofday:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_settimeofday
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__ioctl
	.type	__ioctl, %function
__ioctl:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_ioctl
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__brk
	.type	__brk, %function
__brk:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_brk
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	__getdents
	.type	__getdents, %function
__getdents:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_getdents
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret

	.globl	____getcwd
	.type	____getcwd, %function
____getcwd:
	sub	sp, sp, #0x32
	str	x8, [sp, #0]
	mov	x8, #SYS_getcwd
	svc	0
	ldr	x8, [sp, #0]
	add	sp, sp, #0x32
	ret
#endif
#endif
