OUTPUT_ARCH(sh)
ENTRY("_start")

PHDRS
{
	headers PT_PHDR PHDRS ;
	text PT_LOAD FILEHDR PHDRS ;
	data PT_LOAD ;
	stack PT_GNU_STACK FLAGS(0x6) ;
}

SECTIONS
{
	.text 0x402000 : {
		*(.note.gnu.build-id) /* for Linux */
		*(.text .text.*)
		_etext = .;
	} :text

	/*
	 * When .rodata section becomes the independent segment,
	 * the program may be downed at the time of start.
	 * For example, such a thing may happen when you use clang and nllibc.
	 * (probably because the flag of the .rodata section has SHF_MERGE
	 *  and SHF_STRINGS?)
	 * Therefore, .rodata section is stored away to the segment
	 * same as .text section explicitly.
	 * (or you can keep it off with --no-rosegment option of the linker)
	 */
	.rodata : {
		*(.rodata .rodata.*)
		_erodata = .;
	} :text

	. = ALIGN(0x1000);

	.data : {
		*(.data .data.*)
		*(.sdata .sdata.*)
		_edata = .;
	} :data

	.bss : {
		*(.bss .bss.*)
		*(.sbss .sbss.*)
		*(.scommon)
		*(COMMON)
		_ebss = .;
	} :data

	_end = .;
}
