#ifndef __NLLIBC_SYS_WAIT_H_INCLUDED__
#define __NLLIBC_SYS_WAIT_H_INCLUDED__

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)

#define WNOHANG     1
#define WUNTRACED   2
#define WSTOPPED   WUNTRACED
#define WCONTINUED  4
#define WNOWAIT     8
#define WEXITED    16

#define WCOREFLAG    0x80 /* 0200 */
#define _WSTOPPED    0x7f /* 0177 */
#define _W_CONTINUED 0x13
#define _WSTATUS(x)  ((x) & 0x7f) /* 0177 */

#define WSTOPSIG(x)     (WEXITSTATUS(x))
#define WTERMSIG(x)     (_WSTATUS(x))
#define WEXITSTATUS(x)  ((x) >> 8)
#define WCOREDUMP(x)    ((x) & WCOREFLAG)

#define WIFSTOPPED(x)   (_WSTATUS(x) == _WSTOPPED)
#define WIFEXITED(x)    (_WSTATUS(x) == 0)
#define WIFCONTINUED(x) ((x) == _W_CONTINUED)
#define WIFSIGNALED(x)  (!WIFSTOPPED(x) && !WIFEXITED(x) && !WIFCONTINUED(x))

#define W_EXITCODE(ret, sig) ((ret) << 8 | (sig))
#define W_STOPCODE(sig)      ((sig) << 8 | _WSTOPPED)

#endif

#if defined(__linux__)

#define WNOHANG    0x00000001
#define WUNTRACED  0x00000002
#define WSTOPPED   WUNTRACED
#define WCONTINUED 0x00000008
#define WNOWAIT    0x01000000
#define WEXITED    0x00000004

#define WCOREFLAG      0x80 /* 0200 */
#define _WSTOPPED      0x7f /* 0177 */
#define _W_CONTINUED 0xffff
#define _WSTATUS(x)  ((x) & 0x7f) /* 0177 */

#define WSTOPSIG(x)     (WEXITSTATUS(x))
#define WTERMSIG(x)     (_WSTATUS(x))
#define WEXITSTATUS(x)  (((x) & 0xff00) >> 8)
#define WCOREDUMP(x)    ((x) & WCOREFLAG)

#define WIFSTOPPED(x)   (((x) & 0xff) == _WSTOPPED)
#define WIFEXITED(x)    (_WSTATUS(x) == 0)
#define WIFCONTINUED(x) ((x) == _W_CONTINUED)
#define WIFSIGNALED(x)  (((signed char)(_WSTATUS(x) + 1) >> 1) > 0)

#define W_EXITCODE(ret, sig) ((ret) << 8 | (sig))
#define W_STOPCODE(sig)      ((sig) << 8 | _WSTOPPED)

#endif

struct rusage;
pid_t wait4(pid_t wpid, int *status, int options, struct rusage *rusage);

#endif
