#ifndef __NLLIBC_SIGNAL_H_INCLUDED__
#define __NLLIBC_SIGNAL_H_INCLUDED__

#include <sys/types.h>

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)

#define SIGHUP   1
#define SIGINT   2
#define SIGQUIT  3
#define SIGILL   4
#define SIGTRAP  5
#define SIGABRT  6
#define SIGKILL  9
#define SIGBUS  10
#define SIGSEGV 11
#define SIGSYS  12
#define SIGPIPE 13
#define SIGALRM 14
#define SIGTERM 15
#define SIGSTOP 17
#define SIGTSTP 18
#define SIGCONT 19
#define SIGCHLD 20
#define SIGTTIN 21
#define SIGTTOU 22
#define SIGIO   23

typedef void (*sig_t)(int);

#define SIG_DFL ((sig_t) 0)
#define SIG_IGN ((sig_t) 1)
#define SIG_ERR ((sig_t)-1)

#define SA_ONSTACK   0x0001
#define SA_RESTART   0x0002
#define SA_RESETHAND 0x0004
#define SA_NOCLDSTOP 0x0008
#define SA_NODEFER   0x0010
#define SA_NOCLDWAIT 0x0020
#define SA_SIGINFO   0x0040

typedef struct {
  unsigned int __bits[4];
} sigset_t;

struct siginfo;

struct sigaction {
  union {
    void (*__sa_handler)(int);
    void (*__sa_sigaction)(int, struct siginfo *, void *);
  } __sigaction_u;
  int sa_flags;
  sigset_t sa_mask;
};
#define sa_handler   __sigaction_u.__sa_handler
#define sa_sigaction __sigaction_u.__sa_sigaction

typedef struct __ucontext *ucontext_t;
int sigreturn(const ucontext_t *scp);

#endif

#if defined(__linux__)

#define SIGHUP   1
#define SIGINT   2
#define SIGQUIT  3
#define SIGILL   4
#define SIGTRAP  5
#define SIGABRT  6
#define SIGKILL  9
#define SIGBUS   7
#define SIGSEGV 11
#define SIGSYS  31
#define SIGPIPE 13
#define SIGALRM 14
#define SIGTERM 15
#define SIGSTOP 19
#define SIGTSTP 20
#define SIGCONT 18
#define SIGCHLD 17
#define SIGTTIN 21
#define SIGTTOU 22
#define SIGIO   29

typedef void (*sig_t)(int);

#define SIG_DFL ((sig_t) 0)
#define SIG_IGN ((sig_t) 1)
#define SIG_ERR ((sig_t)-1)

#define SA_ONSTACK   0x08000000
#define SA_RESTART   0x10000000
#define SA_RESETHAND 0x80000000
#define SA_NOCLDSTOP 0x00000001
#define SA_NODEFER   0x40000000
#define SA_NOCLDWAIT 0x00000002
#define SA_SIGINFO   0x00000004

#if defined(__i386__) || defined(__arm__) || defined(__aarch64__) || defined(__sh__) || defined(__amd64__) || defined(__mips__) || defined(__PPC__) || defined(__sparc__)
#define SA_RESTORER  0x04000000 /* Linux only */
#endif

typedef struct {
  unsigned int sig[2];
} sigset_t;

struct siginfo;
struct sigaction;

#if defined(__i386__) || defined(__arm__) || defined(__aarch64__) || defined(__sh__) || defined(__bfin__) || defined(__mn10300__) || defined(__m32r__) || defined(__microblaze__)
struct sigaction {
  union {
    void (*__sa_handler)(int);
    void (*__sa_sigaction)(int, struct siginfo *, void *);
  } __sigaction_u;
  sigset_t sa_mask;
  unsigned long sa_flags;
#ifdef SA_RESTORER
  void (*sa_restorer)(void);
#endif
};
#endif
#if defined(__amd64__) || defined(__hppa__)
struct sigaction {
  union {
    void (*__sa_handler)(int);
    void (*__sa_sigaction)(int, struct siginfo *, void *);
  } __sigaction_u;
  unsigned long sa_flags;
#ifdef SA_RESTORER
  void (*sa_restorer)(void);
#endif
  sigset_t sa_mask;
};
#endif
#if defined(__mips__)
struct sigaction {
  unsigned int sa_flags;
  union {
    void (*__sa_handler)(int);
    void (*__sa_sigaction)(int, struct siginfo *, void *);
  } __sigaction_u;
  sigset_t sa_mask;
#ifdef SA_RESTORER
  void (*sa_restorer)(void);
#endif
  int reserved;
};
#endif
#if defined(__PPC__)
struct sigaction {
  union {
    void (*__sa_handler)(int);
    void (*__sa_sigaction)(int, struct siginfo *, void *);
  } __sigaction_u;
  unsigned long sa_flags;
#ifdef SA_RESTORER
  void (*sa_restorer)(void);
#endif
  sigset_t sa_mask;
};
#endif
#if defined(__sparc__)
struct sigaction {
  union {
    void (*__sa_handler)(int);
    void (*__sa_sigaction)(int, struct siginfo *, void *);
  } __sigaction_u;
  sigset_t sa_mask;
  int reserved;
  unsigned int sa_flags;
#ifdef SA_RESTORER
  void (*sa_restorer)(void);
#endif
};
#endif
#if defined(__alpha__)
struct sigaction {
  union {
    void (*__sa_handler)(int);
    void (*__sa_sigaction)(int, struct siginfo *, void *);
  } __sigaction_u;
  sigset_t sa_mask;
  unsigned int sa_flags;
};
#endif
#define sa_handler   __sigaction_u.__sa_handler
#define sa_sigaction __sigaction_u.__sa_sigaction

struct sigcontext;
int sigreturn(struct sigcontext *scp);

#endif

#ifdef WIN32

#define SIGINT   2
#define SIGILL   4
#define SIGABRT 22
#define SIGSEGV 11
#define SIGTERM 15

typedef void (*sig_t)(int);

#define SIG_DFL ((sig_t) 0)
#define SIG_IGN ((sig_t) 1)
#define SIG_ERR ((sig_t)-1)

typedef int sigset_t;

#endif

int kill(pid_t pid, int sig);

int sigaction(int sig, const struct sigaction *act, struct sigaction *oact);
int sigprocmask(int how, const sigset_t *set, sigset_t *oset);

int killpg(pid_t pgrp, int sig);

#endif
