#ifndef __NLLIBC_H_INCLUDED__
#define __NLLIBC_H_INCLUDED__

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)
#define __ALLBSD__
#endif

#if defined(__ALLBSD__)
#ifdef feof
#undef feof
#endif
#ifdef ferror
#undef ferror
#endif
#ifdef fileno
#undef fileno
#endif
#endif

#if defined(__ALLBSD__) || defined(__linux__)

#ifdef stdin
#undef stdin
extern FILE *stdin;
#endif
#ifdef stdout
#undef stdout
extern FILE *stdout;
#endif
#ifdef stderr
#undef stderr
extern FILE *stderr;
#endif

#define USE_ERRNO_FUNCTION
#ifndef USE_ERRNO_FUNCTION
#ifdef errno
#undef errno
extern int errno;
#endif
#endif

#ifdef isalnum
#undef isalnum
int isalnum(int c);
#endif
#ifdef isalpha
#undef isalpha
int isalpha(int c);
#endif
#ifdef isascii
#undef isascii
int isascii(int c);
#endif
#ifdef iscntrl
#undef iscntrl
int iscntrl(int c);
#endif
#ifdef isdigit
#undef isdigit
int isdigit(int c);
#endif
#ifdef isgraph
#undef isgraph
int isgraph(int c);
#endif
#ifdef islower
#undef islower
int islower(int c);
#endif
#ifdef isprint
#undef isprint
int isprint(int c);
#endif
#ifdef ispunct
#undef ispunct
int ispunct(int c);
#endif
#ifdef isspace
#undef isspace
int isspace(int c);
#endif
#ifdef isupper
#undef isupper
int isupper(int c);
#endif
#ifdef isxdigit
#undef isxdigit
int isxdigit(int c);
#endif
#ifdef tolower
#undef tolower
int tolower(int c);
#endif
#ifdef toupper
#undef toupper
int toupper(int c);
#endif

#endif

int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);

#endif
