#ifndef __NLL_NLLLIB_H_INCLUDED__
#define __NLL_NLLLIB_H_INCLUDED__

enum {
  NLL_ERRCODE_UNKNOWN                      = -  1,

  NLL_ERRCODE_FILE_NOT_FOUND               = - 10,

  NLL_ERRCODE_LINE_NOT_EMPTY               = - 20,
  NLL_ERRCODE_LINE_BUFFER_OVER             = - 21,
  NLL_ERRCODE_LINE_TOO_LONG                = - 22,
  NLL_ERRCODE_LINE_NOT_FOUND               = - 23,

  NLL_ERRCODE_VARIABLE_NOT_EMPTY           = - 30,
  NLL_ERRCODE_VARIABLE_INVALID_NAME        = - 31,
  NLL_ERRCODE_VARIABLE_TOO_LONG            = - 32,
  NLL_ERRCODE_VARIABLE_BUFFER_OVER         = - 33,
  NLL_ERRCODE_VARIABLE_NOT_FOUND           = - 34,

  NLL_ERRCODE_VALUE_NOT_EMPTY              = - 40,
  NLL_ERRCODE_VALUE_BUFFER_OVER            = - 41,
  NLL_ERRCODE_VALUE_INVALID_TYPE           = - 42,
  NLL_ERRCODE_VALUE_CONST_VALUE            = - 43,
  NLL_ERRCODE_VALUE_EMPTY_VALUE            = - 44,

  NLL_ERRCODE_FORMULA_NOT_EMPTY            = - 50,
  NLL_ERRCODE_FORMULA_BUFFER_OVER          = - 51,
  NLL_ERRCODE_FORMULA_LESS_PARAMETER       = - 52,
  NLL_ERRCODE_FORMULA_MUCH_PARAMETER       = - 53,
  NLL_ERRCODE_FORMULA_DIV_ZERO             = - 54,
  NLL_ERRCODE_FORMULA_INVALID_OPERATOR     = - 55,
  NLL_ERRCODE_FORMULA_INVALID_PARAMETER    = - 56,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_OPERATOR = - 57,
  NLL_ERRCODE_FORMULA_UNKNOWN_FUNCTION     = - 58,
  NLL_ERRCODE_FORMULA_NULL_POINTER         = - 59,
  NLL_ERRCODE_FORMULA_INVALID_POINTER      = - 60,
  NLL_ERRCODE_FORMULA_UNSUPPORTED_FUNCTION = - 61,

  NLL_ERRCODE_LABEL_NOT_EMPTY              = - 70,
  NLL_ERRCODE_LABEL_BUFFER_OVER            = - 71,
  NLL_ERRCODE_LABEL_INVALID_NAME           = - 72,
  NLL_ERRCODE_LABEL_TOO_LONG               = - 73,
  NLL_ERRCODE_LABEL_NOT_FOUND              = - 74,
  NLL_ERRCODE_LABEL_DUPLICATE              = - 75,

  NLL_ERRCODE_POSITION_NOT_EMPTY           = - 80,
  NLL_ERRCODE_POSITION_STACK_OVER          = - 81,
  NLL_ERRCODE_POSITION_NOT_FOUND           = - 82,
  NLL_ERRCODE_POSITION_DIFFERENT_TYPE      = - 83,
  NLL_ERRCODE_POSITION_DIFFERENT_VARIABLE  = - 84,

  NLL_ERRCODE_COMMAND_NOT_EMPTY            = - 90,
  NLL_ERRCODE_COMMAND_BUFFER_OVER          = - 91,
  NLL_ERRCODE_COMMAND_TOO_LONG             = - 92,
  NLL_ERRCODE_COMMAND_NOT_FOUND            = - 93,
  NLL_ERRCODE_COMMAND_MUCH_ARGS            = - 94,
  NLL_ERRCODE_COMMAND_INVALID_FORMAT       = - 95,

  NLL_ERRCODE_STRING_NOT_EMPTY             = -100,
  NLL_ERRCODE_STRING_TOO_LONG              = -101,
  NLL_ERRCODE_STRING_BUFFER_OVER           = -102,

  NLL_ERRCODE_ARRAY_NOT_EMPTY              = -110,
  NLL_ERRCODE_ARRAY_BUFFER_OVER            = -111,
  NLL_ERRCODE_ARRAY_OUT_OF_RANGE           = -112,
  NLL_ERRCODE_ARRAY_INVALID_PARAMETER      = -113,

  NLL_ERRCODE_AREA_NOT_EMPTY               = -120,
  NLL_ERRCODE_AREA_BUFFER_OVER             = -121,
  NLL_ERRCODE_AREA_OUT_OF_RANGE            = -122,

  NLL_ERRCODE_STACK_NOT_EMPTY              = -130,
  NLL_ERRCODE_STACK_STACK_OVER             = -131,
  NLL_ERRCODE_STACK_NOT_FOUND              = -132,

  NLL_ERRCODE_MEMORY_NOT_EMPTY             = -140,
  NLL_ERRCODE_MEMORY_BUFFER_OVER           = -141,
  NLL_ERRCODE_MEMORY_INVALID_TYPE          = -142,
  NLL_ERRCODE_MEMORY_INVALID_PARAMETER     = -143,

  NLL_ERRCODE_NLL_SYNTAX_ERROR             = -150,
  NLL_ERRCODE_NLL_SYMBOL_TOO_LONG          = -151,
  NLL_ERRCODE_NLL_NO_CONTINUE_POINT        = -152,
  NLL_ERRCODE_NLL_INVALID_COMMAND          = -153,
  NLL_ERRCODE_NLL_NO_DATA                  = -154,
};

extern FILE *nll_stdin;
extern FILE *nll_stdout;

void nll_error_print(const char *filename, int line,
		     int errcode, const char *param);

void nll_error_exit(const char *filename, int line,
		    int errcode, const char *param);

#define NLL_ERRPRINT(r, param) \
	nll_error_print(__FILE__, __LINE__, r, param)

#define NLL_ERREXIT(r, param) \
	nll_error_exit(__FILE__, __LINE__, r, param)

void nll_usleep(int usec);
void nll_sleep(int sec);
int nll_is_nosystem(void);
int nll_nosystem_set(void);
int nll_is_nosyscall(void);
int nll_nosyscall_set(void);
int nll_is_nonetwork(void);
int nll_nonetwork_set(void);
int nll_is_nofixed(void);
int nll_nofixed_set(void);
int nll_is_tty(void);
int nll_tty_clear(void);
int nll_tty_set(void);
int nll_is_initialize(void);
int nll_initialize_clear(void);
int nll_initialize_set(void);
int nll_edit(void);
int nll_edit_clear(void);
int nll_edit_set(int line);
void nll_finished_clear(void);
void nll_finish(void);
int nll_is_finished(void);
int nll_finish_lock(int locked);
int nll_finish_is_locked(void);
int nll_file_stdin(void);
int nll_file_open(const char *filename);
int nll_file_close(void);
int nll_file_allclose(void);
FILE *nll_file_fp(void);
int nll_stdin_save(FILE *fp);
int nll_stdin_restore(void);
int nll_stdout_save(FILE *fp);
int nll_stdout_restore(void);
int nll_wait_output(FILE *fp);
char *nll_fgets(char *str, int size, FILE *fp);

#endif
