#ifndef __NLL_AUDIO_H_INCLUDED__
#define __NLL_AUDIO_H_INCLUDED__

int audio_check(void);
int audio_init(void);
int audio_done(void);
int audio_stop(void);
int audio_clear(int aunitset_index);
int audio_clear_all(void);
int audio_getsamplefreq(void);
int audio_setsamplefreq(int samplefreq);
int audio_playnum(void);
int audio_wait(void);
int audio_unitset(int aunitset_index);
int audio_unit(int output, int amp, int flags, int aunitset_index);
int audio_osc(int index, int amp, int freq, int phase, int type, int mod, int flags, int aunitset_index);
int audio_addout(int index, int output, int amp, int flags, int aunitset_index);
int audio_envpoint(int index, int n, int step, int amp, int flags, int aunitset_index);
int audio_envcopy(int index, int source, int flags, int aunitset_index);
int audio_filpoint(int index, int type, int n, int amp, int flags, int aunitset_index);
int audio_filcopy(int index, int source, int flags, int aunitset_index);
int audio_play(const char *mml, int flags, int aunitset_index, const char *filename);
int audio_open(char *filename, int *lengthp, unsigned int flags);
int audio_close(int index);

/* for AUDIO_EXTERNAL_DRIVER */
typedef int (*ext_audio_callback_t)(int channels, int samples, short *buffer, void *arg);
int ext_audio_init(void);
int ext_audio_done(void);
int ext_audio_run(int freq, int channels, int samples, ext_audio_callback_t callback, void *arg);
int ext_audio_stop(void);
int ext_audio_wait(void);

#endif
