#ifndef __NLSYS_ASM_FORMAT_H_INCLUDED__
#define __NLSYS_ASM_FORMAT_H_INCLUDED__

typedef enum {
  ASM_FORMAT_TYPE_NONE,

  ASM_FORMAT_TYPE_TYPE_OBJECT,
  ASM_FORMAT_TYPE_TYPE_FUNCTION,

  ASM_FORMAT_TYPE_VALUE_BYTE,
  ASM_FORMAT_TYPE_VALUE_SHORT,
  ASM_FORMAT_TYPE_VALUE_INT,
  ASM_FORMAT_TYPE_VALUE_QUAD,

  ASM_FORMAT_TYPE_SECTION_TEXT,
  ASM_FORMAT_TYPE_SECTION_DATA,
} asm_format_type_t;

void asm_format_comment(FILE *out, char *comment, char *param1, char *param2, char *param3);
void asm_format_newline(FILE *out);
void asm_format_align(FILE *out, int size);
void asm_format_space(FILE *out, int size);
void asm_format_label(FILE *out, char *label);
void asm_format_globl(FILE *out, char *name);
void asm_format_type(FILE *out, char *name, char *prefix, asm_format_type_t type);
void asm_format_size(FILE *out, char *name, int size);

void asm_format_dummy(FILE *out);
void asm_format_string(FILE *out, char *string, int size);
void asm_format_value(FILE *out, asm_format_type_t type, long number, char *name);

void asm_format_section(FILE *out, asm_format_type_t type);

#endif
