#if defined(__linux__)
#if defined(__sparc__)

/*
 * Use Linux system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4         7
#define SYS_kill         37
#define SYS_execve       59

#define SYS_read          3
#define SYS_write         4
#define SYS_open          5
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         90
#define SYS_pipe2       321

#define SYS_sigaction   198 /* rt_sigaction is 102 */
#define SYS_sigprocmask 220 /* rt_sigprocmask is 103 */
#define SYS_sigreturn   216 /* rt_sigreturn is 101 */

#define SYS_getpid       20
#define SYS_getppid     197
#define SYS_getsid      252
#define SYS_setsid      175
#define SYS_getpgid     224
#define SYS_setpgid     185
#define SYS_getpgrp      81

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir      176
#define SYS_chmod        15
#define SYS_chown        13
#define SYS_lseek        19
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl        92
#define SYS_fsync        95
#define SYS_fchown      123
#define SYS_fchmod      124
#define SYS_rename      128

#define SYS_mkdir       136
#define SYS_rmdir       137

#define SYS_mmap         71
#define SYS_munmap       73

#define SYS_truncate    129
#define SYS_ftruncate   130

#define SYS_select       93
#define SYS_pselect     297

#define SYS_gettimeofday 116
#define SYS_settimeofday 122

#define SYS_ioctl        54
#define SYS_brk          17
#define SYS_getdents    174
#define SYS_getcwd      119

	.section .text

	.globl	___exit
	.type	___exit, @function
___exit:
	mov	SYS_exit, %g1
	b	_syscall
	nop

	.globl	__fork
	.type	__fork, @function
__fork:
	mov	SYS_fork, %g1
	b	_syscall
	nop

	.globl	__wait4
	.type	__wait4, @function
__wait4:
	mov	SYS_wait4, %g1
	b	_syscall
	nop

	.globl	__kill
	.type	__kill, @function
__kill:
	mov	SYS_kill, %g1
	b	_syscall
	nop

	.globl	__execve
	.type	__execve, @function
__execve:
	mov	SYS_execve, %g1
	b	_syscall
	nop

	.globl	__read
	.type	__read, @function
__read:
	mov	SYS_read, %g1
	b	_syscall
	nop

	.globl	__write
	.type	__write, @function
__write:
	mov	SYS_write, %g1
	b	_syscall
	nop

	.globl	__open
	.type	__open, @function
__open:
	mov	SYS_open, %g1
	b	_syscall
	nop

	.globl	__close
	.type	__close, @function
__close:
	mov	SYS_close, %g1
	b	_syscall
	nop

	.globl	__dup
	.type	__dup, @function
__dup:
	mov	SYS_dup, %g1
	b	_syscall
	nop

	.globl	__pipe
	.type	__pipe, @function
__pipe:
	mov	SYS_pipe, %g1
	b	_syscall
	nop

	.globl	__dup2
	.type	__dup2, @function
__dup2:
	mov	SYS_dup2, %g1
	b	_syscall
	nop

	.globl	__pipe2
	.type	__pipe2, @function
__pipe2:
	mov	SYS_pipe2, %g1
	b	_syscall
	nop

	.globl	__sigaction
	.type	__sigaction, @function
__sigaction:
	mov	SYS_sigaction, %g1
	b	_syscall
	nop

	.globl	__sigprocmask
	.type	__sigprocmask, @function
__sigprocmask:
	mov	SYS_sigprocmask, %g1
	b	_syscall
	nop

	.globl	__sigreturn
	.type	__sigreturn, @function
__sigreturn:
	mov	SYS_sigreturn, %g1
	b	_syscall
	nop

	.globl	__getpid
	.type	__getpid, @function
__getpid:
	mov	SYS_getpid, %g1
	b	_syscall
	nop

	.globl	__getppid
	.type	__getppid, @function
__getppid:
	mov	SYS_getppid, %g1
	b	_syscall
	nop

	.globl	__getsid
	.type	__getsid, @function
__getsid:
	mov	SYS_getsid, %g1
	b	_syscall
	nop

	.globl	__setsid
	.type	__setsid, @function
__setsid:
	mov	SYS_setsid, %g1
	b	_syscall
	nop

	.globl	__getpgid
	.type	__getpgid, @function
__getpgid:
	mov	SYS_getpgid, %g1
	b	_syscall
	nop

	.globl	__setpgid
	.type	__setpgid, @function
__setpgid:
	mov	SYS_setpgid, %g1
	b	_syscall
	nop

	.globl	__getpgrp
	.type	__getpgrp, @function
__getpgrp:
	mov	SYS_getpgrp, %g1
	b	_syscall
	nop

	.globl	__unlink
	.type	__unlink, @function
__unlink:
	mov	SYS_unlink, %g1
	b	_syscall
	nop

	.globl	__chdir
	.type	__chdir, @function
__chdir:
	mov	SYS_chdir, %g1
	b	_syscall
	nop

	.globl	__fchdir
	.type	__fchdir, @function
__fchdir:
	mov	SYS_fchdir, %g1
	b	_syscall
	nop

	.globl	__chmod
	.type	__chmod, @function
__chmod:
	mov	SYS_chmod, %g1
	b	_syscall
	nop

	.globl	__chown
	.type	__chown, @function
__chown:
	mov	SYS_chown, %g1
	b	_syscall
	nop

	.globl	__lseek
	.type	__lseek, @function
__lseek:
	mov	SYS_lseek, %g1
	b	_syscall
	nop

	.globl	__access
	.type	__access, @function
__access:
	mov	SYS_access, %g1
	b	_syscall
	nop

	.globl	__sync
	.type	__sync, @function
__sync:
	mov	SYS_sync, %g1
	b	_syscall
	nop

	.globl	__fcntl
	.type	__fcntl, @function
__fcntl:
	mov	SYS_fcntl, %g1
	b	_syscall
	nop

	.globl	__fsync
	.type	__fsync, @function
__fsync:
	mov	SYS_fsync, %g1
	b	_syscall
	nop

	.globl	__fchown
	.type	__fchown, @function
__fchown:
	mov	SYS_fchown, %g1
	b	_syscall
	nop

	.globl	__fchmod
	.type	__fchmod, @function
__fchmod:
	mov	SYS_fchmod, %g1
	b	_syscall
	nop

	.globl	__rename
	.type	__rename, @function
__rename:
	mov	SYS_rename, %g1
	b	_syscall
	nop

	.globl	__mkdir
	.type	__mkdir, @function
__mkdir:
	mov	SYS_mkdir, %g1
	b	_syscall
	nop

	.globl	__rmdir
	.type	__rmdir, @function
__rmdir:
	mov	SYS_rmdir, %g1
	b	_syscall
	nop

	.globl	__mmap
	.type	__mmap, @function
__mmap:
	mov	SYS_mmap, %g1
	b	_syscall
	nop

	.globl	__munmap
	.type	__munmap, @function
__munmap:
	mov	SYS_munmap, %g1
	b	_syscall
	nop

	.globl	__truncate
	.type	__truncate, @function
__truncate:
	mov	SYS_truncate, %g1
	b	_syscall
	nop

	.globl	__ftruncate
	.type	__ftruncate, @function
__ftruncate:
	mov	SYS_ftruncate, %g1
	b	_syscall
	nop

	.globl	__select
	.type	__select, @function
__select:
	mov	SYS_select, %g1
	b	_syscall
	nop

	.globl	__pselect
	.type	__pselect, @function
__pselect:
	mov	SYS_pselect, %g1
	b	_syscall
	nop

	.globl	__gettimeofday
	.type	__gettimeofday, @function
__gettimeofday:
	mov	SYS_gettimeofday, %g1
	b	_syscall
	nop

	.globl	__settimeofday
	.type	__settimeofday, @function
__settimeofday:
	mov	SYS_settimeofday, %g1
	b	_syscall
	nop

	.globl	__ioctl
	.type	__ioctl, @function
__ioctl:
	mov	SYS_ioctl, %g1
	b	_syscall
	nop

	.globl	__brk
	.type	__brk, @function
__brk:
	mov	SYS_brk, %g1
	b	_syscall
	nop

	.globl	__getdents
	.type	__getdents, @function
__getdents:
	mov	SYS_getdents, %g1
	b	_syscall
	nop

	.globl	____getcwd
	.type	____getcwd, @function
____getcwd:
	mov	SYS_getcwd, %g1
	b	_syscall
	nop

_syscall:
	ta	0x10
	bcc	ret
	nop

err:	neg	%o0
ret:	retl
	nop
#endif
#endif
