#if defined(__linux__)
#if defined(__sh__)

/*
 * Use Linux system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4       114
#define SYS_kill         37
#define SYS_execve       11

#define SYS_read          3
#define SYS_write         4
#define SYS_open          5
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         63
#define SYS_pipe2       331

#define SYS_sigaction    67 /* rt_sigaction is 174 */
#define SYS_sigprocmask 126 /* rt_sigprocmask is 175 */
#define SYS_sigreturn   119 /* rt_sigreturn is 173 */

#define SYS_getpid       20
#define SYS_getppid      64
#define SYS_getsid      147
#define SYS_setsid       66
#define SYS_getpgid     132
#define SYS_setpgid      57
#define SYS_getpgrp      65

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir      133
#define SYS_chmod        15
#define SYS_chown       182
#define SYS_lseek        19
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl        55
#define SYS_fsync       118
#define SYS_fchown       95
#define SYS_fchmod       94
#define SYS_rename       38

#define SYS_mkdir        39
#define SYS_rmdir        40

#define SYS_mmap         90
#define SYS_munmap       91

#define SYS_truncate     92
#define SYS_ftruncate    93

#define SYS_select      142 /* newselect */
#define SYS_pselect     308

#define SYS_gettimeofday 78
#define SYS_settimeofday 79

#define SYS_ioctl        54
#define SYS_brk          45
#define SYS_getdents    141
#define SYS_getcwd      183

	.section .text

	.globl	____exit
	.type	____exit, @function
____exit:
	mov	#SYS_exit, r3
	trapa	#0x17
	rts
	nop

	.globl	___fork
	.type	___fork, @function
___fork:
	mov	#SYS_fork, r3
	trapa	#0x17
	rts
	nop

	.globl	___wait4
	.type	___wait4, @function
___wait4:
	mov	#SYS_wait4, r3
	trapa	#0x17
	rts
	nop

	.globl	___kill
	.type	___kill, @function
___kill:
	mov	#SYS_kill, r3
	trapa	#0x17
	rts
	nop

	.globl	___execve
	.type	___execve, @function
___execve:
	mov	#SYS_execve, r3
	trapa	#0x17
	rts
	nop

	.globl	___read
	.type	___read, @function
___read:
	mov	#SYS_read, r3
	trapa	#0x17
	rts
	nop

	.globl	___write
	.type	___write, @function
___write:
	mov	#SYS_write, r3
	trapa	#0x17
	rts
	nop

	.globl	___open
	.type	___open, @function
___open:
	mov	#SYS_open, r3
	trapa	#0x17
	rts
	nop

	.globl	___close
	.type	___close, @function
___close:
	mov	#SYS_close, r3
	trapa	#0x17
	rts
	nop

	.globl	___dup
	.type	___dup, @function
___dup:
	mov	#SYS_dup, r3
	trapa	#0x17
	rts
	nop

	.globl	___pipe
	.type	___pipe, @function
___pipe:
	mov	#SYS_pipe, r3
	trapa	#0x17
	rts
	nop

	.globl	___dup2
	.type	___dup2, @function
___dup2:
	mov	#SYS_dup2, r3
	trapa	#0x17
	rts
	nop

	.globl	___pipe2
	.type	___pipe2, @function
___pipe2:
	mov.l	1f, r3
	trapa	#0x17
	rts
	nop
	.align	2
1:	.long	SYS_pipe2

	.globl	___sigaction
	.type	___sigaction, @function
___sigaction:
	mov	#SYS_sigaction, r3
	trapa	#0x17
	rts
	nop

	.globl	___sigprocmask
	.type	___sigprocmask, @function
___sigprocmask:
	mov	#SYS_sigprocmask, r3
	trapa	#0x17
	rts
	nop

	.globl	___sigreturn
	.type	___sigreturn, @function
___sigreturn:
	mov	#SYS_sigreturn, r3
	trapa	#0x17
	rts
	nop

	.globl	___getpid
	.type	___getpid, @function
___getpid:
	mov	#SYS_getpid, r3
	trapa	#0x17
	rts
	nop

	.globl	___getppid
	.type	___getppid, @function
___getppid:
	mov	#SYS_getppid, r3
	trapa	#0x17
	rts
	nop

	.globl	___getsid
	.type	___getsid, @function
___getsid:
	mov	#SYS_getsid, r3
	trapa	#0x17
	rts
	nop

	.globl	___setsid
	.type	___setsid, @function
___setsid:
	mov	#SYS_setsid, r3
	trapa	#0x17
	rts
	nop

	.globl	___getpgid
	.type	___getpgid, @function
___getpgid:
	mov	#SYS_getpgid, r3
	trapa	#0x17
	rts
	nop

	.globl	___setpgid
	.type	___setpgid, @function
___setpgid:
	mov	#SYS_setpgid, r3
	trapa	#0x17
	rts
	nop

	.globl	___getpgrp
	.type	___getpgrp, @function
___getpgrp:
	mov	#SYS_getpgrp, r3
	trapa	#0x17
	rts
	nop

	.globl	___unlink
	.type	___unlink, @function
___unlink:
	mov	#SYS_unlink, r3
	trapa	#0x17
	rts
	nop

	.globl	___chdir
	.type	___chdir, @function
___chdir:
	mov	#SYS_chdir, r3
	trapa	#0x17
	rts
	nop

	.globl	___fchdir
	.type	___fchdir, @function
___fchdir:
	mov	#SYS_fchdir, r3
	trapa	#0x17
	rts
	nop

	.globl	___chmod
	.type	___chmod, @function
___chmod:
	mov	#SYS_chmod, r3
	trapa	#0x17
	rts
	nop

	.globl	___chown
	.type	___chown, @function
___chown:
	mov	#SYS_chown, r3
	trapa	#0x17
	rts
	nop

	.globl	___lseek
	.type	___lseek, @function
___lseek:
	mov	#SYS_lseek, r3
	trapa	#0x17
	rts
	nop

	.globl	___access
	.type	___access, @function
___access:
	mov	#SYS_access, r3
	trapa	#0x17
	rts
	nop

	.globl	___sync
	.type	___sync, @function
___sync:
	mov	#SYS_sync, r3
	trapa	#0x17
	rts
	nop

	.globl	___fcntl
	.type	___fcntl, @function
___fcntl:
	mov	#SYS_fcntl, r3
	trapa	#0x17
	rts
	nop

	.globl	___fsync
	.type	___fsync, @function
___fsync:
	mov	#SYS_fsync, r3
	trapa	#0x17
	rts
	nop

	.globl	___fchown
	.type	___fchown, @function
___fchown:
	mov	#SYS_fchown, r3
	trapa	#0x17
	rts
	nop

	.globl	___fchmod
	.type	___fchmod, @function
___fchmod:
	mov	#SYS_fchmod, r3
	trapa	#0x17
	rts
	nop

	.globl	___rename
	.type	___rename, @function
___rename:
	mov	#SYS_rename, r3
	trapa	#0x17
	rts
	nop

	.globl	___mkdir
	.type	___mkdir, @function
___mkdir:
	mov	#SYS_mkdir, r3
	trapa	#0x17
	rts
	nop

	.globl	___rmdir
	.type	___rmdir, @function
___rmdir:
	mov	#SYS_rmdir, r3
	trapa	#0x17
	rts
	nop

	.globl	___mmap
	.type	___mmap, @function
___mmap:
	mov	#SYS_mmap, r3
	trapa	#0x17
	rts
	nop

	.globl	___munmap
	.type	___munmap, @function
___munmap:
	mov	#SYS_munmap, r3
	trapa	#0x17
	rts
	nop

	.globl	___truncate
	.type	___truncate, @function
___truncate:
	mov	#SYS_truncate, r3
	trapa	#0x17
	rts
	nop

	.globl	___ftruncate
	.type	___ftruncate, @function
___ftruncate:
	mov	#SYS_ftruncate, r3
	trapa	#0x17
	rts
	nop

	.globl	___select
	.type	___select, @function
___select:
	mov	#SYS_select, r3
	trapa	#0x17
	rts
	nop

	.globl	___pselect
	.type	___pselect, @function
___pselect:
	mov	#SYS_pselect, r3
	trapa	#0x17
	rts
	nop

	.globl	___gettimeofday
	.type	___gettimeofday, @function
___gettimeofday:
	mov	#SYS_gettimeofday, r3
	trapa	#0x17
	rts
	nop

	.globl	___settimeofday
	.type	___settimeofday, @function
___settimeofday:
	mov	#SYS_settimeofday, r3
	trapa	#0x17
	rts
	nop

	.globl	___ioctl
	.type	___ioctl, @function
___ioctl:
	mov	#SYS_ioctl, r3
	trapa	#0x17
	rts
	nop

	.globl	___brk
	.type	___brk, @function
___brk:
	mov	#SYS_brk, r3
	trapa	#0x17
	rts
	nop

	.globl	___getdents
	.type	___getdents, @function
___getdents:
	mov	#SYS_getdents, r3
	trapa	#0x17
	rts
	nop

	.globl	_____getcwd
	.type	_____getcwd, @function
_____getcwd:
	mov	#SYS_getcwd, r3
	trapa	#0x17
	rts
	nop
#endif
#endif
