#if defined(__linux__)
#if defined(__mips__)

/*
 * Use Linux system call.
 */

#define SYS_exit        (4000 +   1)
#define SYS_fork        (4000 +   2)
#define SYS_wait4       (4000 + 114)
#define SYS_kill        (4000 +  37)
#define SYS_execve      (4000 +  11)

#define SYS_read        (4000 +   3)
#define SYS_write       (4000 +   4)
#define SYS_open        (4000 +   5)
#define SYS_close       (4000 +   6)

#define SYS_dup         (4000 +  41)
#define SYS_pipe        (4000 +  42)
#define SYS_dup2        (4000 +  63)
#define SYS_pipe2       (4000 + 328)

#define SYS_sigaction   (4000 +  67) /* rt_sigaction is 194 */
#define SYS_sigprocmask (4000 + 126) /* rt_sigprocmask is 195 */
#define SYS_sigreturn   (4000 + 119) /* rt_sigreturn is 193 */

#define SYS_getpid      (4000 +  20)
#define SYS_getppid     (4000 +  64)
#define SYS_getsid      (4000 + 151)
#define SYS_setsid      (4000 +  66)
#define SYS_getpgid     (4000 + 132)
#define SYS_setpgid     (4000 +  57)
#define SYS_getpgrp     (4000 +  65)

#define SYS_unlink      (4000 +  10)
#define SYS_chdir       (4000 +  12)
#define SYS_fchdir      (4000 + 133)
#define SYS_chmod       (4000 +  15)
#define SYS_chown       (4000 + 202)
#define SYS_lseek       (4000 +  19)
#define SYS_access      (4000 +  33)
#define SYS_sync        (4000 +  36)
#define SYS_fcntl       (4000 +  55)
#define SYS_fsync       (4000 + 118)
#define SYS_fchown      (4000 +  95)
#define SYS_fchmod      (4000 +  94)
#define SYS_rename      (4000 +  38)

#define SYS_mkdir       (4000 +  39)
#define SYS_rmdir       (4000 +  40)

#define SYS_mmap        (4000 +  90)
#define SYS_munmap      (4000 +  91)

#define SYS_truncate    (4000 +  92)
#define SYS_ftruncate   (4000 +  93)

#define SYS_select      (4000 + 142) /* newselect */
#define SYS_pselect     (4000 + 301)

#define SYS_gettimeofday (4000 + 78)
#define SYS_settimeofday (4000 + 79)

#define SYS_ioctl       (4000 +  54)
#define SYS_brk         (4000 +  45)
#define SYS_getdents    (4000 + 141)
#define SYS_getcwd      (4000 + 203)

	.section .text

	.globl	___exit
	.type	___exit, @function
___exit:
	li	$v0, SYS_exit
	b	_syscall
	nop

	.globl	__fork
	.type	__fork, @function
__fork:
	li	$v0, SYS_fork
	b	_syscall
	nop

	.globl	__wait4
	.type	__wait4, @function
__wait4:
	li	$v0, SYS_wait4
	b	_syscall
	nop

	.globl	__kill
	.type	__kill, @function
__kill:
	li	$v0, SYS_kill
	b	_syscall
	nop

	.globl	__execve
	.type	__execve, @function
__execve:
	li	$v0, SYS_execve
	b	_syscall
	nop

	.globl	__read
	.type	__read, @function
__read:
	li	$v0, SYS_read
	b	_syscall
	nop

	.globl	__write
	.type	__write, @function
__write:
	li	$v0, SYS_write
	b	_syscall
	nop

	.globl	__open
	.type	__open, @function
__open:
	li	$v0, SYS_open
	b	_syscall
	nop

	.globl	__close
	.type	__close, @function
__close:
	li	$v0, SYS_close
	b	_syscall
	nop

	.globl	__dup
	.type	__dup, @function
__dup:
	li	$v0, SYS_dup
	b	_syscall
	nop

	.globl	__pipe
	.type	__pipe, @function
__pipe:
	li	$v0, SYS_pipe
	b	_syscall
	nop

	.globl	__dup2
	.type	__dup2, @function
__dup2:
	li	$v0, SYS_dup2
	b	_syscall
	nop

	.globl	__pipe2
	.type	__pipe2, @function
__pipe2:
	li	$v0, SYS_pipe2
	b	_syscall
	nop

	.globl	__sigaction
	.type	__sigaction, @function
__sigaction:
	li	$v0, SYS_sigaction
	b	_syscall
	nop

	.globl	__sigprocmask
	.type	__sigprocmask, @function
__sigprocmask:
	li	$v0, SYS_sigprocmask
	b	_syscall
	nop

	.globl	__sigreturn
	.type	__sigreturn, @function
__sigreturn:
	li	$v0, SYS_sigreturn
	b	_syscall
	nop

	.globl	__getpid
	.type	__getpid, @function
__getpid:
	li	$v0, SYS_getpid
	b	_syscall
	nop

	.globl	__getppid
	.type	__getppid, @function
__getppid:
	li	$v0, SYS_getppid
	b	_syscall
	nop

	.globl	__getsid
	.type	__getsid, @function
__getsid:
	li	$v0, SYS_getsid
	b	_syscall
	nop

	.globl	__setsid
	.type	__setsid, @function
__setsid:
	li	$v0, SYS_setsid
	b	_syscall
	nop

	.globl	__getpgid
	.type	__getpgid, @function
__getpgid:
	li	$v0, SYS_getpgid
	b	_syscall
	nop

	.globl	__setpgid
	.type	__setpgid, @function
__setpgid:
	li	$v0, SYS_setpgid
	b	_syscall
	nop

	.globl	__getpgrp
	.type	__getpgrp, @function
__getpgrp:
	li	$v0, SYS_getpgrp
	b	_syscall
	nop

	.globl	__unlink
	.type	__unlink, @function
__unlink:
	li	$v0, SYS_unlink
	b	_syscall
	nop

	.globl	__chdir
	.type	__chdir, @function
__chdir:
	li	$v0, SYS_chdir
	b	_syscall
	nop

	.globl	__fchdir
	.type	__fchdir, @function
__fchdir:
	li	$v0, SYS_fchdir
	b	_syscall
	nop

	.globl	__chmod
	.type	__chmod, @function
__chmod:
	li	$v0, SYS_chmod
	b	_syscall
	nop

	.globl	__chown
	.type	__chown, @function
__chown:
	li	$v0, SYS_chown
	b	_syscall
	nop

	.globl	__lseek
	.type	__lseek, @function
__lseek:
	li	$v0, SYS_lseek
	b	_syscall
	nop

	.globl	__access
	.type	__access, @function
__access:
	li	$v0, SYS_access
	b	_syscall
	nop

	.globl	__sync
	.type	__sync, @function
__sync:
	li	$v0, SYS_sync
	b	_syscall
	nop

	.globl	__fcntl
	.type	__fcntl, @function
__fcntl:
	li	$v0, SYS_fcntl
	b	_syscall
	nop

	.globl	__fsync
	.type	__fsync, @function
__fsync:
	li	$v0, SYS_fsync
	b	_syscall
	nop

	.globl	__fchown
	.type	__fchown, @function
__fchown:
	li	$v0, SYS_fchown
	b	_syscall
	nop

	.globl	__fchmod
	.type	__fchmod, @function
__fchmod:
	li	$v0, SYS_fchmod
	b	_syscall
	nop

	.globl	__rename
	.type	__rename, @function
__rename:
	li	$v0, SYS_rename
	b	_syscall
	nop

	.globl	__mkdir
	.type	__mkdir, @function
__mkdir:
	li	$v0, SYS_mkdir
	b	_syscall
	nop

	.globl	__rmdir
	.type	__rmdir, @function
__rmdir:
	li	$v0, SYS_rmdir
	b	_syscall
	nop

	.globl	__mmap
	.type	__mmap, @function
__mmap:
	li	$v0, SYS_mmap
	b	_syscall
	nop

	.globl	__munmap
	.type	__munmap, @function
__munmap:
	li	$v0, SYS_munmap
	b	_syscall
	nop

	.globl	__truncate
	.type	__truncate, @function
__truncate:
	li	$v0, SYS_truncate
	b	_syscall
	nop

	.globl	__ftruncate
	.type	__ftruncate, @function
__ftruncate:
	li	$v0, SYS_ftruncate
	b	_syscall
	nop

	.globl	__select
	.type	__select, @function
__select:
	li	$v0, SYS_select
	b	_syscall
	nop

	.globl	__pselect
	.type	__pselect, @function
__pselect:
	li	$v0, SYS_pselect
	b	_syscall
	nop

	.globl	__gettimeofday
	.type	__gettimeofday, @function
__gettimeofday:
	li	$v0, SYS_gettimeofday
	b	_syscall
	nop

	.globl	__settimeofday
	.type	__settimeofday, @function
__settimeofday:
	li	$v0, SYS_settimeofday
	b	_syscall
	nop

	.globl	__ioctl
	.type	__ioctl, @function
__ioctl:
	li	$v0, SYS_ioctl
	b	_syscall
	nop

	.globl	__brk
	.type	__brk, @function
__brk:
	li	$v0, SYS_brk
	b	_syscall
	nop

	.globl	__getdents
	.type	__getdents, @function
__getdents:
	li	$v0, SYS_getdents
	b	_syscall
	nop

	.globl	____getcwd
	.type	____getcwd, @function
____getcwd:
	li	$v0, SYS_getcwd
	b	_syscall
	nop

_syscall:
	syscall
	beqz	$a3, ret
	nop

err:	negu	$v0
ret:	jr	$ra
	nop
#endif
#endif
