#if defined(__linux__)
#if defined(__microblaze__)

/*
 * Use Linux system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4       114
#define SYS_kill         37
#define SYS_execve       11

#define SYS_read          3
#define SYS_write         4
#define SYS_open          5
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         63
#define SYS_pipe2       343

#define SYS_sigaction    67 /* rt_sigaction is 174 */
#define SYS_sigprocmask 126 /* rt_sigprocmask is 175 */
#define SYS_sigreturn   119 /* rt_sigreturn is 173 */

#define SYS_getpid       20
#define SYS_getppid      64
#define SYS_getsid      147
#define SYS_setsid       66
#define SYS_getpgid     132
#define SYS_setpgid      57
#define SYS_getpgrp      65

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir      133
#define SYS_chmod        15
#define SYS_chown       182
#define SYS_lseek        19
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl        55
#define SYS_fsync       118
#define SYS_fchown       95
#define SYS_fchmod       94
#define SYS_rename       38

#define SYS_mkdir        39
#define SYS_rmdir        40

#define SYS_mmap         90
#define SYS_munmap       91

#define SYS_truncate     92
#define SYS_ftruncate    93

#define SYS_select      142 /* newselect(remove) */
#define SYS_pselect     308

#define SYS_gettimeofday 78
#define SYS_settimeofday 79

#define SYS_ioctl        54
#define SYS_brk          45
#define SYS_getdents    141
#define SYS_getcwd      183

	.section .text

	.globl	___exit
	.type	___exit, @function
___exit:
	addik	r12, r0, SYS_exit
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__fork
	.type	__fork, @function
__fork:
	addik	r12, r0, SYS_fork
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__wait4
	.type	__wait4, @function
__wait4:
	addik	r12, r0, SYS_wait4
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__kill
	.type	__kill, @function
__kill:
	addik	r12, r0, SYS_kill
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__execve
	.type	__execve, @function
__execve:
	addik	r12, r0, SYS_execve
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__read
	.type	__read, @function
__read:
	addik	r12, r0, SYS_read
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__write
	.type	__write, @function
__write:
	addik	r12, r0, SYS_write
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__open
	.type	__open, @function
__open:
	addik	r12, r0, SYS_open
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__close
	.type	__close, @function
__close:
	addik	r12, r0, SYS_close
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__dup
	.type	__dup, @function
__dup:
	addik	r12, r0, SYS_dup
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__pipe
	.type	__pipe, @function
__pipe:
	addik	r12, r0, SYS_pipe
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__dup2
	.type	__dup2, @function
__dup2:
	addik	r12, r0, SYS_dup2
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__pipe2
	.type	__pipe2, @function
__pipe2:
	addik	r12, r0, SYS_pipe2
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__sigaction
	.type	__sigaction, @function
__sigaction:
	addik	r12, r0, SYS_sigaction
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__sigprocmask
	.type	__sigprocmask, @function
__sigprocmask:
	addik	r12, r0, SYS_sigprocmask
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__sigreturn
	.type	__sigreturn, @function
__sigreturn:
	addik	r12, r0, SYS_sigreturn
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__getpid
	.type	__getpid, @function
__getpid:
	addik	r12, r0, SYS_getpid
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__getppid
	.type	__getppid, @function
__getppid:
	addik	r12, r0, SYS_getppid
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__getsid
	.type	__getsid, @function
__getsid:
	addik	r12, r0, SYS_getsid
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__setsid
	.type	__setsid, @function
__setsid:
	addik	r12, r0, SYS_setsid
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__getpgid
	.type	__getpgid, @function
__getpgid:
	addik	r12, r0, SYS_getpgid
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__setpgid
	.type	__setpgid, @function
__setpgid:
	addik	r12, r0, SYS_setpgid
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__getpgrp
	.type	__getpgrp, @function
__getpgrp:
	addik	r12, r0, SYS_getpgrp
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__unlink
	.type	__unlink, @function
__unlink:
	addik	r12, r0, SYS_unlink
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__chdir
	.type	__chdir, @function
__chdir:
	addik	r12, r0, SYS_chdir
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__fchdir
	.type	__fchdir, @function
__fchdir:
	addik	r12, r0, SYS_fchdir
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__chmod
	.type	__chmod, @function
__chmod:
	addik	r12, r0, SYS_chmod
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__chown
	.type	__chown, @function
__chown:
	addik	r12, r0, SYS_chown
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__lseek
	.type	__lseek, @function
__lseek:
	addik	r12, r0, SYS_lseek
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__access
	.type	__access, @function
__access:
	addik	r12, r0, SYS_access
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__sync
	.type	__sync, @function
__sync:
	addik	r12, r0, SYS_sync
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__fcntl
	.type	__fcntl, @function
__fcntl:
	addik	r12, r0, SYS_fcntl
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__fsync
	.type	__fsync, @function
__fsync:
	addik	r12, r0, SYS_fsync
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__fchown
	.type	__fchown, @function
__fchown:
	addik	r12, r0, SYS_fchown
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__fchmod
	.type	__fchmod, @function
__fchmod:
	addik	r12, r0, SYS_fchmod
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__rename
	.type	__rename, @function
__rename:
	addik	r12, r0, SYS_rename
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__mkdir
	.type	__mkdir, @function
__mkdir:
	addik	r12, r0, SYS_mkdir
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__rmdir
	.type	__rmdir, @function
__rmdir:
	addik	r12, r0, SYS_rmdir
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__mmap
	.type	__mmap, @function
__mmap:
	addik	r12, r0, SYS_mmap
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__munmap
	.type	__munmap, @function
__munmap:
	addik	r12, r0, SYS_munmap
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__truncate
	.type	__truncate, @function
__truncate:
	addik	r12, r0, SYS_truncate
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__ftruncate
	.type	__ftruncate, @function
__ftruncate:
	addik	r12, r0, SYS_ftruncate
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__select
	.type	__select, @function
__select:
	addik	r12, r0, SYS_select
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__pselect
	.type	__pselect, @function
__pselect:
	addik	r12, r0, SYS_pselect
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__gettimeofday
	.type	__gettimeofday, @function
__gettimeofday:
	addik	r12, r0, SYS_gettimeofday
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__settimeofday
	.type	__settimeofday, @function
__settimeofday:
	addik	r12, r0, SYS_settimeofday
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__ioctl
	.type	__ioctl, @function
__ioctl:
	addik	r12, r0, SYS_ioctl
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__brk
	.type	__brk, @function
__brk:
	addik	r12, r0, SYS_brk
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	__getdents
	.type	__getdents, @function
__getdents:
	addik	r12, r0, SYS_getdents
	brki	r14, 8
	rtsd	r15, 8
	nop

	.globl	____getcwd
	.type	____getcwd, @function
____getcwd:
	addik	r12, r0, SYS_getcwd
	brki	r14, 8
	rtsd	r15, 8
	nop
#endif
#endif
