#if defined(__linux__)
#if defined(__bfin__)

/*
 * Use Linux system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4       114
#define SYS_kill         37
#define SYS_execve       11

#define SYS_read          3
#define SYS_write         4
#define SYS_open          5
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         63
#define SYS_pipe2       364

#define SYS_sigaction    67 /* rt_sigaction is 174 */
#define SYS_sigprocmask 126 /* rt_sigprocmask is 175 */
#define SYS_sigreturn   119 /* rt_sigreturn is 173 */

#define SYS_getpid       20
#define SYS_getppid      64
#define SYS_getsid      147
#define SYS_setsid       66
#define SYS_getpgid     132
#define SYS_setpgid      57
#define SYS_getpgrp      65

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir      133
#define SYS_chmod        15
#define SYS_chown        16
#define SYS_lseek        19
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl        55
#define SYS_fsync       118
#define SYS_fchown       95
#define SYS_fchmod       94
#define SYS_rename       38

#define SYS_mkdir        39
#define SYS_rmdir        40

#define SYS_mmap         90 /* obsolete */
#define SYS_munmap       91

#define SYS_truncate     92
#define SYS_ftruncate    93

#define SYS_select      142 /* newselect(obsolete) */
#define SYS_pselect     308

#define SYS_gettimeofday 78
#define SYS_settimeofday 79

#define SYS_ioctl        54
#define SYS_brk          45
#define SYS_getdents    141
#define SYS_getcwd      183

	.section .text

	.globl	____exit
	.type	____exit, @function
____exit:
	P0	= SYS_exit
	EXCPT	0
	RTS

	.globl	___fork
	.type	___fork, @function
___fork:
	P0	= SYS_fork
	EXCPT	0
	RTS

	.globl	___wait4
	.type	___wait4, @function
___wait4:
	P0	= SYS_wait4
	EXCPT	0
	RTS

	.globl	___kill
	.type	___kill, @function
___kill:
	P0	= SYS_kill
	EXCPT	0
	RTS

	.globl	___execve
	.type	___execve, @function
___execve:
	P0	= SYS_execve
	EXCPT	0
	RTS

	.globl	___read
	.type	___read, @function
___read:
	P0	= SYS_read
	EXCPT	0
	RTS

	.globl	___write
	.type	___write, @function
___write:
	P0	= SYS_write
	EXCPT	0
	RTS

	.globl	___open
	.type	___open, @function
___open:
	P0	= SYS_open
	EXCPT	0
	RTS

	.globl	___close
	.type	___close, @function
___close:
	P0	= SYS_close
	EXCPT	0
	RTS

	.globl	___dup
	.type	___dup, @function
___dup:
	P0	= SYS_dup
	EXCPT	0
	RTS

	.globl	___pipe
	.type	___pipe, @function
___pipe:
	P0	= SYS_pipe
	EXCPT	0
	RTS

	.globl	___dup2
	.type	___dup2, @function
___dup2:
	P0	= SYS_dup2
	EXCPT	0
	RTS

	.globl	___pipe2
	.type	___pipe2, @function
___pipe2:
	P0	= SYS_pipe2
	EXCPT	0
	RTS

	.globl	___sigaction
	.type	___sigaction, @function
___sigaction:
	P0	= SYS_sigaction
	EXCPT	0
	RTS

	.globl	___sigprocmask
	.type	___sigprocmask, @function
___sigprocmask:
	P0	= SYS_sigprocmask
	EXCPT	0
	RTS

	.globl	___sigreturn
	.type	___sigreturn, @function
___sigreturn:
	P0	= SYS_sigreturn
	EXCPT	0
	RTS

	.globl	___getpid
	.type	___getpid, @function
___getpid:
	P0	= SYS_getpid
	EXCPT	0
	RTS

	.globl	___getppid
	.type	___getppid, @function
___getppid:
	P0	= SYS_getppid
	EXCPT	0
	RTS

	.globl	___getsid
	.type	___getsid, @function
___getsid:
	P0	= SYS_getsid
	EXCPT	0
	RTS

	.globl	___setsid
	.type	___setsid, @function
___setsid:
	P0	= SYS_setsid
	EXCPT	0
	RTS

	.globl	___getpgid
	.type	___getpgid, @function
___getpgid:
	P0	= SYS_getpgid
	EXCPT	0
	RTS

	.globl	___setpgid
	.type	___setpgid, @function
___setpgid:
	P0	= SYS_setpgid
	EXCPT	0
	RTS

	.globl	___getpgrp
	.type	___getpgrp, @function
___getpgrp:
	P0	= SYS_getpgrp
	EXCPT	0
	RTS

	.globl	___unlink
	.type	___unlink, @function
___unlink:
	P0	= SYS_unlink
	EXCPT	0
	RTS

	.globl	___chdir
	.type	___chdir, @function
___chdir:
	P0	= SYS_chdir
	EXCPT	0
	RTS

	.globl	___fchdir
	.type	___fchdir, @function
___fchdir:
	P0	= SYS_fchdir
	EXCPT	0
	RTS

	.globl	___chmod
	.type	___chmod, @function
___chmod:
	P0	= SYS_chmod
	EXCPT	0
	RTS

	.globl	___chown
	.type	___chown, @function
___chown:
	P0	= SYS_chown
	EXCPT	0
	RTS

	.globl	___lseek
	.type	___lseek, @function
___lseek:
	P0	= SYS_lseek
	EXCPT	0
	RTS

	.globl	___access
	.type	___access, @function
___access:
	P0	= SYS_access
	EXCPT	0
	RTS

	.globl	___sync
	.type	___sync, @function
___sync:
	P0	= SYS_sync
	EXCPT	0
	RTS

	.globl	___fcntl
	.type	___fcntl, @function
___fcntl:
	P0	= SYS_fcntl
	EXCPT	0
	RTS

	.globl	___fsync
	.type	___fsync, @function
___fsync:
	P0	= SYS_fsync
	EXCPT	0
	RTS

	.globl	___fchown
	.type	___fchown, @function
___fchown:
	P0	= SYS_fchown
	EXCPT	0
	RTS

	.globl	___fchmod
	.type	___fchmod, @function
___fchmod:
	P0	= SYS_fchmod
	EXCPT	0
	RTS

	.globl	___rename
	.type	___rename, @function
___rename:
	P0	= SYS_rename
	EXCPT	0
	RTS

	.globl	___mkdir
	.type	___mkdir, @function
___mkdir:
	P0	= SYS_mkdir
	EXCPT	0
	RTS

	.globl	___rmdir
	.type	___rmdir, @function
___rmdir:
	P0	= SYS_rmdir
	EXCPT	0
	RTS

	.globl	___mmap
	.type	___mmap, @function
___mmap:
	P0	= SYS_mmap
	EXCPT	0
	RTS

	.globl	___munmap
	.type	___munmap, @function
___munmap:
	P0	= SYS_munmap
	EXCPT	0
	RTS

	.globl	___truncate
	.type	___truncate, @function
___truncate:
	P0	= SYS_truncate
	EXCPT	0
	RTS

	.globl	___ftruncate
	.type	___ftruncate, @function
___ftruncate:
	P0	= SYS_ftruncate
	EXCPT	0
	RTS

	.globl	___select
	.type	___select, @function
___select:
	P0	= SYS_select
	EXCPT	0
	RTS

	.globl	___pselect
	.type	___pselect, @function
___pselect:
	P0	= SYS_pselect
	EXCPT	0
	RTS

	.globl	___gettimeofday
	.type	___gettimeofday, @function
___gettimeofday:
	P0	= SYS_gettimeofday
	EXCPT	0
	RTS

	.globl	___settimeofday
	.type	___settimeofday, @function
___settimeofday:
	P0	= SYS_settimeofday
	EXCPT	0
	RTS

	.globl	___ioctl
	.type	___ioctl, @function
___ioctl:
	P0	= SYS_ioctl
	EXCPT	0
	RTS

	.globl	___brk
	.type	___brk, @function
___brk:
	P0	= SYS_brk
	EXCPT	0
	RTS

	.globl	___getdents
	.type	___getdents, @function
___getdents:
	P0	= SYS_getdents
	EXCPT	0
	RTS

	.globl	_____getcwd
	.type	_____getcwd, @function
_____getcwd:
	P0	= SYS_getcwd
	EXCPT	0
	RTS
#endif
#endif
