#if defined(__linux__)
#if defined(__arm__)

/*
 * Use Linux system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4       114
#define SYS_kill         37
#define SYS_execve       11

#define SYS_read          3
#define SYS_write         4
#define SYS_open          5
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         63
#define SYS_pipe2       359

#define SYS_sigaction    67 /* rt_sigaction is 174 */
#define SYS_sigprocmask 126 /* rt_sigprocmask is 175 */
#define SYS_sigreturn   119 /* rt_sigreturn is 173 */

#define SYS_getpid       20
#define SYS_getppid      64
#define SYS_getsid      147
#define SYS_setsid       66
#define SYS_getpgid     132
#define SYS_setpgid      57
#define SYS_getpgrp      65

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir      133
#define SYS_chmod        15
#define SYS_chown       182
#define SYS_lseek        19
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl        55
#define SYS_fsync       118
#define SYS_fchown       95
#define SYS_fchmod       94
#define SYS_rename       38

#define SYS_mkdir        39
#define SYS_rmdir        40

#define SYS_mmap         90
#define SYS_munmap       91

#define SYS_truncate     92
#define SYS_ftruncate    93

#define SYS_select      142 /* newselect */
#define SYS_pselect     335

#define SYS_gettimeofday 78
#define SYS_settimeofday 79

#define SYS_ioctl        54
#define SYS_brk          45
#define SYS_getdents    141
#define SYS_getcwd      183

	.section .text

	.globl	___exit
	.type	___exit, %function
___exit:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_exit
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__fork
	.type	__fork, %function
__fork:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_fork
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__wait4
	.type	__wait4, %function
__wait4:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_wait4
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__kill
	.type	__kill, %function
__kill:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_kill
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__execve
	.type	__execve, %function
__execve:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_execve
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__read
	.type	__read, %function
__read:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_read
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__write
	.type	__write, %function
__write:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_write
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__open
	.type	__open, %function
__open:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_open
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__close
	.type	__close, %function
__close:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_close
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__dup
	.type	__dup, %function
__dup:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_dup
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__pipe
	.type	__pipe, %function
__pipe:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_pipe
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__dup2
	.type	__dup2, %function
__dup2:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_dup2
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__pipe2
	.type	__pipe2, %function
__pipe2:
	push	{ r4, r5, r6, r7 }
	mov	r7, #(SYS_pipe2 & 0xff00)
	add	r7, r7, #(SYS_pipe2 & 0xff)
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__sigaction
	.type	__sigaction, %function
__sigaction:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_sigaction
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__sigprocmask
	.type	__sigprocmask, %function
__sigprocmask:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_sigprocmask
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__sigreturn
	.type	__sigreturn, %function
__sigreturn:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_sigreturn
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__getpid
	.type	__getpid, %function
__getpid:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_getpid
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__getppid
	.type	__getppid, %function
__getppid:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_getppid
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__getsid
	.type	__getsid, %function
__getsid:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_getsid
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__setsid
	.type	__setsid, %function
__setsid:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_setsid
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__getpgid
	.type	__getpgid, %function
__getpgid:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_getpgid
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__setpgid
	.type	__setpgid, %function
__setpgid:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_setpgid
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__getpgrp
	.type	__getpgrp, %function
__getpgrp:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_getpgrp
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__unlink
	.type	__unlink, %function
__unlink:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_unlink
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__chdir
	.type	__chdir, %function
__chdir:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_chdir
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__fchdir
	.type	__fchdir, %function
__fchdir:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_fchdir
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__chmod
	.type	__chmod, %function
__chmod:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_chmod
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__chown
	.type	__chown, %function
__chown:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_chown
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__lseek
	.type	__lseek, %function
__lseek:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_lseek
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__access
	.type	__access, %function
__access:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_access
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__sync
	.type	__sync, %function
__sync:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_sync
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__fcntl
	.type	__fcntl, %function
__fcntl:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_fcntl
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__fsync
	.type	__fsync, %function
__fsync:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_fsync
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__fchown
	.type	__fchown, %function
__fchown:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_fchown
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__fchmod
	.type	__fchmod, %function
__fchmod:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_fchmod
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__rename
	.type	__rename, %function
__rename:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_rename
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__mkdir
	.type	__mkdir, %function
__mkdir:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_mkdir
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__rmdir
	.type	__rmdir, %function
__rmdir:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_rmdir
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__mmap
	.type	__mmap, %function
__mmap:
	push	{ r4, r5, r6, r7 }
	ldr	r4, [sp, #16]
	ldr	r5, [sp, #20]
	mov	r7, #SYS_mmap
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__munmap
	.type	__munmap, %function
__munmap:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_munmap
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__truncate
	.type	__truncate, %function
__truncate:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_truncate
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__ftruncate
	.type	__ftruncate, %function
__ftruncate:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_ftruncate
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__select
	.type	__select, %function
__select:
	push	{ r4, r5, r6, r7 }
	ldr	r4, [sp, #16]
	mov	r7, #SYS_select
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__pselect
	.type	__pselect, %function
__pselect:
	push	{ r4, r5, r6, r7 }
	ldr	r4, [sp, #16]
	ldr	r5, [sp, #20]
	mov	r7, #SYS_pselect
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__gettimeofday
	.type	__gettimeofday, %function
__gettimeofday:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_gettimeofday
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__settimeofday
	.type	__settimeofday, %function
__settimeofday:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_settimeofday
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__ioctl
	.type	__ioctl, %function
__ioctl:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_ioctl
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__brk
	.type	__brk, %function
__brk:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_brk
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	__getdents
	.type	__getdents, %function
__getdents:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_getdents
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr

	.globl	____getcwd
	.type	____getcwd, %function
____getcwd:
	push	{ r4, r5, r6, r7 }
	mov	r7, #SYS_getcwd
	swi	0
	pop	{ r4, r5, r6, r7 }
	mov	pc, lr
#endif
#endif
