#if defined(__linux__)
#if defined(__alpha__)

/*
 * Use Linux system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4         7
#define SYS_kill         37
#define SYS_execve       11

#define SYS_read          3
#define SYS_write         4
#define SYS_open         45
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         90
#define SYS_pipe2       SYS_pipe /* Not exist (use pipe) */

#define SYS_sigaction   156 /* rt_sigaction is 352 */
#define SYS_sigprocmask  48 /* rt_sigprocmask is 353 */
#define SYS_sigreturn   103 /* rt_sigreturn is 351 */

#define SYS_getpid       20 /* Not exist (use getxpid) */
#define SYS_getppid     XXX /* Not exist */
#define SYS_getsid      234
#define SYS_setsid      147
#define SYS_getpgid     233
#define SYS_setpgid      39
#define SYS_getpgrp      63

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir       13
#define SYS_chmod        15
#define SYS_chown        16
#define SYS_lseek        19
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl        92
#define SYS_fsync        95
#define SYS_fchown      123
#define SYS_fchmod      124
#define SYS_rename      128

#define SYS_mkdir       136
#define SYS_rmdir       137

#define SYS_mmap         71
#define SYS_munmap       73

#define SYS_truncate    129
#define SYS_ftruncate   130

#define SYS_select      358
#define SYS_pselect     463

#define SYS_gettimeofday 359
#define SYS_settimeofday 360

#define SYS_ioctl        54
#define SYS_brk          17
#define SYS_getdents    305
#define SYS_getcwd      367

	.section .text

	.globl	___exit
	.type	___exit, @function
___exit:
	ldq	$0, SYS_exit
	jmp	_syscall

	.globl	__fork
	.type	__fork, @function
__fork:
	ldq	$0, SYS_fork
	jmp	_syscall

	.globl	__wait4
	.type	__wait4, @function
__wait4:
	ldq	$0, SYS_wait4
	jmp	_syscall

	.globl	__kill
	.type	__kill, @function
__kill:
	ldq	$0, SYS_kill
	jmp	_syscall

	.globl	__execve
	.type	__execve, @function
__execve:
	ldq	$0, SYS_execve
	jmp	_syscall

	.globl	__read
	.type	__read, @function
__read:
	ldq	$0, SYS_read
	jmp	_syscall

	.globl	__write
	.type	__write, @function
__write:
	ldq	$0, SYS_write
	jmp	_syscall

	.globl	__open
	.type	__open, @function
__open:
	ldq	$0, SYS_open
	jmp	_syscall

	.globl	__close
	.type	__close, @function
__close:
	ldq	$0, SYS_close
	jmp	_syscall

	.globl	__dup
	.type	__dup, @function
__dup:
	ldq	$0, SYS_dup
	jmp	_syscall

	.globl	__pipe
	.type	__pipe, @function
__pipe:
	ldq	$0, SYS_pipe
	jmp	_syscall

	.globl	__dup2
	.type	__dup2, @function
__dup2:
	ldq	$0, SYS_dup2
	jmp	_syscall

	.globl	__pipe2
	.type	__pipe2, @function
__pipe2:
	ldq	$0, SYS_pipe2
	jmp	_syscall

	.globl	__sigaction
	.type	__sigaction, @function
__sigaction:
	ldq	$0, SYS_sigaction
	jmp	_syscall

	.globl	__sigprocmask
	.type	__sigprocmask, @function
__sigprocmask:
	ldq	$0, SYS_sigprocmask
	jmp	_syscall

	.globl	__sigreturn
	.type	__sigreturn, @function
__sigreturn:
	ldq	$0, SYS_sigreturn
	jmp	_syscall

	.globl	__getpid
	.type	__getpid, @function
__getpid:
	ldq	$0, SYS_getpid
	jmp	_syscall

	.globl	__getppid
	.type	__getppid, @function
__getppid:
#if 0
	ldq	$0, SYS_getppid
	jmp	_syscall
#else
	ldq	$0, -1
	ret
#endif

	.globl	__getsid
	.type	__getsid, @function
__getsid:
	ldq	$0, SYS_getsid
	jmp	_syscall

	.globl	__setsid
	.type	__setsid, @function
__setsid:
	ldq	$0, SYS_setsid
	jmp	_syscall

	.globl	__getpgid
	.type	__getpgid, @function
__getpgid:
	ldq	$0, SYS_getpgid
	jmp	_syscall

	.globl	__setpgid
	.type	__setpgid, @function
__setpgid:
	ldq	$0, SYS_setpgid
	jmp	_syscall

	.globl	__getpgrp
	.type	__getpgrp, @function
__getpgrp:
	ldq	$0, SYS_getpgrp
	jmp	_syscall

	.globl	__unlink
	.type	__unlink, @function
__unlink:
	ldq	$0, SYS_unlink
	jmp	_syscall

	.globl	__chdir
	.type	__chdir, @function
__chdir:
	ldq	$0, SYS_chdir
	jmp	_syscall

	.globl	__fchdir
	.type	__fchdir, @function
__fchdir:
	ldq	$0, SYS_fchdir
	jmp	_syscall

	.globl	__chmod
	.type	__chmod, @function
__chmod:
	ldq	$0, SYS_chmod
	jmp	_syscall

	.globl	__chown
	.type	__chown, @function
__chown:
	ldq	$0, SYS_chown
	jmp	_syscall

	.globl	__lseek
	.type	__lseek, @function
__lseek:
	ldq	$0, SYS_lseek
	jmp	_syscall

	.globl	__access
	.type	__access, @function
__access:
	ldq	$0, SYS_access
	jmp	_syscall

	.globl	__sync
	.type	__sync, @function
__sync:
	ldq	$0, SYS_sync
	jmp	_syscall

	.globl	__fcntl
	.type	__fcntl, @function
__fcntl:
	ldq	$0, SYS_fcntl
	jmp	_syscall

	.globl	__fsync
	.type	__fsync, @function
__fsync:
	ldq	$0, SYS_fsync
	jmp	_syscall

	.globl	__fchown
	.type	__fchown, @function
__fchown:
	ldq	$0, SYS_fchown
	jmp	_syscall

	.globl	__fchmod
	.type	__fchmod, @function
__fchmod:
	ldq	$0, SYS_fchmod
	jmp	_syscall

	.globl	__rename
	.type	__rename, @function
__rename:
	ldq	$0, SYS_rename
	jmp	_syscall

	.globl	__mkdir
	.type	__mkdir, @function
__mkdir:
	ldq	$0, SYS_mkdir
	jmp	_syscall

	.globl	__rmdir
	.type	__rmdir, @function
__rmdir:
	ldq	$0, SYS_rmdir
	jmp	_syscall

	.globl	__mmap
	.type	__mmap, @function
__mmap:
	ldq	$0, SYS_mmap
	jmp	_syscall

	.globl	__munmap
	.type	__munmap, @function
__munmap:
	ldq	$0, SYS_munmap
	jmp	_syscall

	.globl	__truncate
	.type	__truncate, @function
__truncate:
	ldq	$0, SYS_truncate
	jmp	_syscall

	.globl	__ftruncate
	.type	__ftruncate, @function
__ftruncate:
	ldq	$0, SYS_ftruncate
	jmp	_syscall

	.globl	__select
	.type	__select, @function
__select:
	ldq	$0, SYS_select
	jmp	_syscall

	.globl	__pselect
	.type	__pselect, @function
__pselect:
	ldq	$0, SYS_pselect
	jmp	_syscall

	.globl	__gettimeofday
	.type	__gettimeofday, @function
__gettimeofday:
	ldq	$0, SYS_gettimeofday
	jmp	_syscall

	.globl	__settimeofday
	.type	__settimeofday, @function
__settimeofday:
	ldq	$0, SYS_settimeofday
	jmp	_syscall

	.globl	__ioctl
	.type	__ioctl, @function
__ioctl:
	ldq	$0, SYS_ioctl
	jmp	_syscall

	.globl	__brk
	.type	__brk, @function
__brk:
	ldq	$0, SYS_brk
	jmp	_syscall

	.globl	__getdents
	.type	__getdents, @function
__getdents:
	ldq	$0, SYS_getdents
	jmp	_syscall

	.globl	____getcwd
	.type	____getcwd, @function
____getcwd:
	ldq	$0, SYS_getcwd
	jmp	_syscall

_syscall:
	mov	$17, $16 /* a1 -> a0 */
	mov	$18, $17 /* a2 -> a1 */
	mov	$19, $18 /* a3 -> a2 */
	mov	$20, $19 /* a4 -> a3 */
	mov	$21, $20 /* a5 -> a4 */
	callsys
	beq	$19, ret /* check a3 */

err:	negq	$0, $0 /* neg v0 */
ret:	ret
#endif
#endif
