#if defined(__arm__)

#include <stdint.h>

#include "../lib.h"

/* #define PROFILE_ARMV7A */

/* __aeabi_idivmod()/__aeabi_uidivmod() need to return by r1 */
int __aeabi_return_r0_r1(int r0, int r1);

int __aeabi_idiv(int val, int div)
{
#ifdef PROFILE_ARMV7A
  if (!div) return 0;
#endif
  return __divsi3(val, div);
}

int __aeabi_idivmod(int val, int div)
{
#ifdef PROFILE_ARMV7A
  if (!div) return 0;
#endif
  return __aeabi_return_r0_r1(0, __modsi3(val, div));
}

unsigned int __aeabi_uidiv(unsigned int val, unsigned int div)
{
#ifdef PROFILE_ARMV7A
  if (!div) return 0;
#endif
  return __udivsi3(val, div);
}

unsigned int __aeabi_uidivmod(unsigned int val, unsigned int div)
{
#ifdef PROFILE_ARMV7A
  if (!div) return 0;
#endif
  return __aeabi_return_r0_r1(0, __umodsi3(val, div));
}

#endif
