#ifndef __NLLIBC_TERMIOS_H_INCLUDED__
#define __NLLIBC_TERMIOS_H_INCLUDED__

struct termios;
int tcgetattr(int fd, struct termios *t);
int tcsetattr(int fd, int action, const struct termios *t);

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)

struct termios {
  unsigned int c_iflag;
  unsigned int c_oflag;
  unsigned int c_cflag;
  unsigned int c_lflag;
  unsigned char c_cc[20];
  unsigned int c_ispeed;
  unsigned int c_ospeed;
};

#define ECHO   0x00000008
#define ICANON 0x00000100

#define VMIN   16
#define VTIME  17

#define TCSANOW   0
#define TCSADRAIN 1
#define TCSAFLUSH 2
#endif

#if defined(__linux__)
#if defined(__alpha__)
struct termios {
  unsigned int c_iflag;
  unsigned int c_oflag;
  unsigned int c_cflag;
  unsigned int c_lflag;
  unsigned char c_cc[32];
  unsigned char c_line;
  unsigned int c_ispeed;
  unsigned int c_ospeed;
};
#else
struct termios {
  unsigned int c_iflag;
  unsigned int c_oflag;
  unsigned int c_cflag;
  unsigned int c_lflag;
  unsigned char c_line;
  unsigned char c_cc[32];
  unsigned int c_ispeed;
  unsigned int c_ospeed;
};
#endif

#if defined(__PPC__) || defined(__alpha__)
#define ICANON 0000400
#define ECHO   0000010
#else
#define ICANON 0000002
#define ECHO   0000010
#endif

#if defined(__PPC__)
#define VTIME  7
#define VMIN   5
#elif defined(__mips__) || defined(__sparc__)
#define VTIME  5
#define VMIN   4
#elif defined(__alpha__)
#define VTIME 17
#define VMIN  16
#else
#define VTIME  5
#define VMIN   6
#endif

#if defined(__mips__)
#define TCSANOW   0x540e
#define TCSADRAIN 0x540f
#define TCSAFLUSH 0x5410
#else
#define TCSANOW   0
#define TCSADRAIN 1
#define TCSAFLUSH 2
#endif
#endif

#endif
