#ifndef __NLLIBC_SYS_TIME_H_INCLUDED__
#define __NLLIBC_SYS_TIME_H_INCLUDED__

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)
struct timeval {
  time_t tv_sec;
  long tv_usec;
};

struct timezone {
  int tz_minuteswest;
  int tz_dsttime;
};

struct timespec {
  time_t tv_sec;
  long   tv_nsec;
};
#endif

#if defined(__linux__)
struct timeval {
  time_t tv_sec;
  long tv_usec;
};

struct timezone {
  int tz_minuteswest;
  int tz_dsttime;
};

struct timespec {
  time_t tv_sec;
  long tv_nsec;
};

typedef struct timezone *__timezone_ptr_t;
#endif

#ifdef WIN32
struct timeval {
  long tv_sec;
  long tv_usec;
};

struct timezone;
struct timespec;
#endif

int gettimeofday(struct timeval *tp, struct timezone *tzp);
int settimeofday(const struct timeval *tp, const struct timezone *tzp);

#endif
