#ifndef __NLLIBC_ERRNO_H_INCLUDED__
#define __NLLIBC_ERRNO_H_INCLUDED__

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)
int *__error(void);
#define errno (*__error())

#define EPERM    1
#define ENOENT   2
#define ESRCH    3
#define EINTR    4
#define ENOEXEC  8
#define EBADF    9
#define ECHILD  10
#define ENOMEM  12
#define EACCES  13
#define EFAULT  14
#define EBUSY   16
#define EEXIST  17
#define ENODEV  19
#define ENOTDIR 20
#define EISDIR  21
#define EINVAL  22
#define ENOTTY  25
#define ETXTBSY 26
#define ENOSPC  28
#define EPIPE   32
#endif

#if defined(__linux__)
int *__errno_location(void);
#define errno (*__errno_location())

#define EPERM    1
#define ENOENT   2
#define ESRCH    3
#define EINTR    4
#define ENOEXEC  8
#define EBADF    9
#define ECHILD  10
#define ENOMEM  12
#define EACCES  13
#define EFAULT  14
#define EBUSY   16
#define EEXIST  17
#define ENODEV  19
#define ENOTDIR 20
#define EISDIR  21
#define EINVAL  22
#define ENOTTY  25
#define ETXTBSY 26
#define ENOSPC  28
#define EPIPE   32
#endif

#ifdef WIN32
extern int errno;

#define EPERM    1
#define ENOENT   2
#define ESRCH    3
#define EINTR    4
#define ENOEXEC  8
#define EBADF    9
#define ECHILD  10
#define ENOMEM  12
#define EACCES  13
#define EFAULT  14
#define EBUSY   16
#define EEXIST  17
#define ENODEV  19
#define ENOTDIR 20
#define EISDIR  21
#define EINVAL  22
#define ENOTTY  25
#define ENOSPC  28
#define EPIPE   32
#endif

#endif
