#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "const.h"
#include "image.h"
#include "charset.h"

#define CHARACTER_SIZE 32

#define TP 0x80 /* transparent */

#define B_   (1 << 0)
#define B__  (2 << 0)
#define B___ (3 << 0)
#define G_   (1 << 2)
#define G__  (2 << 2)
#define G___ (3 << 2)
#define R_   (1 << 4)
#define R__  (2 << 4)
#define R___ (3 << 4)

#define BK 0x00 /* black */

#define BL (          B___) /* blue */
#define GR (     G___     ) /* green */
#define CY (     G___|B___) /* cyan */
#define RD (R___          ) /* red */
#define MG (R___     |B___) /* magenta */
#define YL (R___|G___     ) /* yellow */
#define WH (R___|G___|B___) /* white */

#define B0 (        B_ )
#define B1 (        B__)
#define G0 (    G_     )
#define G1 (    G__    )
#define C0 (    G_ |B_ )
#define C1 (    G__|B__)
#define R0 (R_         )
#define R1 (R__        )
#define M0 (R_     |B_ )
#define M1 (R__    |B__)
#define Y0 (R_ |G_     )
#define Y1 (R__|G__    )
#define W0 (R_ |G_ |B_ )
#define W1 (R__|G__|B__)

#define C2 (     G_  |B__ )
#define C3 (     G_  |B___)
#define C4 (     G__ |B_  )
#define C5 (     G__ |B___)
#define C6 (     G___|B_  )
#define C7 (     G___|B__ )
#define M2 (R_       |B__ )
#define M3 (R_       |B___)
#define M4 (R__      |B_  )
#define M5 (R__      |B___)
#define M6 (R___     |B_  )
#define M7 (R___     |B__ )
#define Y2 (R_  |G__      )
#define Y3 (R_  |G___     )
#define Y4 (R__ |G_       )
#define Y5 (R__ |G___     )
#define Y6 (R___|G_       )
#define Y7 (R___|G__      )

#define Z0 (R_  |G_  |B__ )
#define Z1 (R_  |G_  |B___)
#define Z2 (R_  |G__ |B_  )
#define Z3 (R_  |G__ |B__ )
#define Z4 (R_  |G__ |B___)
#define Z5 (R_  |G___|B_  )
#define Z6 (R_  |G___|B__ )
#define Z7 (R_  |G___|B___)
#define Z8 (R__ |G_  |B_  )
#define Z9 (R__ |G_  |B__ )
#define ZA (R__ |G_  |B___)
#define ZB (R__ |G__ |B_  )
#define ZC (R__ |G__ |B___)
#define ZD (R__ |G___|B_  )
#define ZE (R__ |G___|B__ )
#define ZF (R__ |G___|B___)
#define ZG (R___|G_  |B_  )
#define ZH (R___|G_  |B__ )
#define ZI (R___|G_  |B___)
#define ZJ (R___|G__ |B_  )
#define ZK (R___|G__ |B__ )
#define ZL (R___|G__ |B___)
#define ZM (R___|G___|B_  )
#define ZN (R___|G___|B__ )

#ifdef USE_GRAPHIC
static GRAPHIC_CHARACTER_PRESET_TYPE unsigned char bitmap[] = {
#ifndef GRAPHIC_CHARACTER_PRESET_LIMITED
  /* brick */
  BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,
  BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,
  BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,
  BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,
  BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,
  BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,

  /* ladder */
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,
  TP,TP,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,TP,TP,

  /* door */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,R1,R1,R1,R1,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,R1,R1,R1,R1,R1,R1,R1,R1,R1,R1,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,R1,R1,R1,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,R1,R1,R1,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,R1,R1,BK,BK,BK,R1,R1,R1,BK,BK,R1,R1,R1,BK,BK,BK,R1,R1,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,R1,BK,BK,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,BK,BK,R1,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,R1,R1,BK,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,BK,R1,R1,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,R1,BK,BK,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,BK,BK,R1,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,WH,WH,R1,R1,BK,BK,R1,R1,WH,WH,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,WH,WH,WH,WH,R1,BK,BK,R1,WH,WH,WH,WH,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,WH,WH,WH,WH,R1,BK,BK,R1,WH,WH,WH,WH,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,WH,WH,R1,R1,BK,BK,R1,R1,WH,WH,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
  TP,TP,TP,TP,R1,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,BK,R1,R1,R1,R1,R1,R1,R1,R1,R1,BK,R1,TP,TP,TP,TP,
#endif
};

const struct charset charset_character_3 = {
  CHARACTER_SIZE, CHARACTER_SIZE,
  sizeof(bitmap) / (sizeof(*bitmap) * CHARACTER_SIZE * CHARACTER_SIZE),
  bitmap, IMAGE_TYPE_ROUGHCOLOR, NLL_G_STATIC
};
#endif
