#ifndef __NLSYS_ENUM_H_INCLUDED__
#define __NLSYS_ENUM_H_INCLUDED__

typedef struct _enum *enum_t;

#include "type.h"
#include "objlist.h"
#include "syntax.h"

struct _enum {
  struct objentry entry;
  char *name;
  int id;
  objlist_t words;
};

/*****************************************************************
 * enum_t
 */

enum_t enum_destroy(enum_t _enum);
enum_t enum_create(char *name, objlist_t words);
void enum_print(enum_t _enum, int indent);

/*****************************************************************
 * library
 */

enum_t enum_list_search(objlist_t list, char *name);
symbol_t enum_search_word(enum_t _enum, char *name);
symbol_t enum_list_search_symbol(objlist_t list, char *name);
symbol_t enum_list_search_symbol_defines(objlist_t defines_list, char *name);
int enum_normalize(syntax_t syntax, objlist_t syntax_list,
		   objlist_t defines_list);

#endif
