#ifndef __NLSYS_ASM_SYMBOL_H_INCLUDED__
#define __NLSYS_ASM_SYMBOL_H_INCLUDED__

#include "symbol.h"

int asm_symbol_tmp_label_reserve(int n);
int asm_symbol_tmp_label_release(int n);
int asm_symbol_tmp_label_current(void);
char *asm_symbol_tmp_label_name(int n);
char *asm_symbol_tmp_label_namef(int n);

int asm_symbol_tmp_reserve(void);
int asm_symbol_tmp_release(void);
int asm_symbol_tmp_current(void);
int asm_symbol_tmp_stack_load(FILE *out, int number);
int asm_symbol_tmp_stack_store(FILE *out, int number);
int asm_symbol_tmp_stack_load_r1(FILE *out, int number);
int asm_symbol_tmp_stack_store_r1(FILE *out, int number);
int asm_symbol_tmp_save(FILE *out, int number);
int asm_symbol_tmp_load(FILE *out, int number);
int asm_symbol_tmp_save_r1(FILE *out, int number);
int asm_symbol_tmp_load_r1(FILE *out, int number);

int asm_symbol_function_call(FILE *out, char *label, int args_number);
int asm_symbol_sign_extension(FILE *out, model_t model);

int asm_symbol_branch_zero(FILE *out, char *label);
int asm_symbol_branch_nzero(FILE *out, char *label);

int asm_symbol_address_get(FILE *out, symbol_t symbol, symbol_t function);
int asm_symbol_value_set(FILE *out, symbol_t symbol, symbol_t function);
int asm_symbol_value_get(FILE *out, symbol_t symbol, symbol_t function);
int asm_symbol(FILE *out, symbol_t symbol);

#endif
