#ifndef __NLSYS_AREA_H_INCLUDED__
#define __NLSYS_AREA_H_INCLUDED__

typedef struct _area *area_t;

#include "type.h"
#include "objlist.h"
#include "area.h"

struct _area {
  c_type_t type;
  int align;
  int offset;
  int size;
  int size_correct;
  int size_init;
  struct {
    int bits;
    int shift;
    int offset;
  } bitfield;
  objlist_t symbols;
};

/*****************************************************************
 * area_t
 */

area_t area_destroy(area_t area);
area_t area_create(c_type_t type);
void area_print_simple(area_t area, int indent);
void area_print(area_t area, int indent);

/*****************************************************************
 * library
 */

symbol_t area_search_symbol(area_t area, char *name);
symbol_t area_insert_symbol(area_t area, symbol_t symbol);

#endif
