#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "string.h"

struct string {
  struct string *next;
  char label[16];
  char s[1];
};

static struct string *head = NULL;

const char *string_alloc(const char *s)
{
  struct string *str;
  static int n = 0;

  str = malloc(sizeof(struct string) + strlen(s));
  if (!str)
    return NULL;

  strcpy(str->s, s);
  sprintf(str->label, ".LC%d", n);

  str->next = head;  
  head = str;

  n++;

  return str->label;
}

int string_flush(FILE *out)
{
  struct string *str;

  fprintf(out, "\n\t.data\n");

  while (head) {
    str = head;
    head = head->next;
    fprintf(out, "%s:\t.string\t\"%s\"\n", str->label, str->s);
    free(str);
  }

  return 0;
}
