#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include <nllibc.h>

#ifndef WIN32
pid_t tcgetpgrp(int fd)
{
  pid_t pgrp_id;
  int s;

  if (ioctl(fd, TIOCGPGRP, &s) < 0)
    s = -1;
  pgrp_id = (pid_t)s;

  return pgrp_id;
}

int tcsetpgrp(int fd, pid_t pgrp_id)
{
  int s = (pid_t)pgrp_id;
  return ioctl(fd, TIOCSPGRP, &s);
}
#endif
