#include <ctype.h>

#include <nllibc.h>

int isalnum(int c)
{
  if (isalpha(c) || isdigit(c))
    return 1;
  return 0;
}

int isalpha(int c)
{
  if (islower(c) || isupper(c))
    return 1;
  return 0;
}

int isascii(int c)
{
  if ((c >= '\0') && (c <= '\x7f'))
    return 1;
  return 0;
}

int iscntrl(int c)
{
  if (((c >= '\0') && (c <= '\x1f')) || (c == '\x7f'))
    return 1;
  return 0;
}

int isdigit(int c)
{
  if ((c >= '0') && (c <= '9'))
    return 1;
  return 0;
}

int isgraph(int c)
{
  if (((c >= '!') && (c <= '~')))
    return 1;
  return 0;
}

int islower(int c)
{
  if ((c >= 'a') && (c <= 'z'))
    return 1;
  return 0;
}

int isprint(int c)
{
  if ((c == ' ') || isgraph(c))
    return 1;
  return 0;
}

int ispunct(int c)
{
  if (((c >= '!') && (c <= '/')) || ((c >= ':') && (c <= '@')) ||
      ((c >= '[') && (c <= '`')) || ((c >= '{') && (c <= '~')))
    return 1;
  return 0;
}

int isspace(int c)
{
  switch (c) {
  case '\t':
  case '\n':
  case '\v':
  case '\f':
  case '\r':
  case ' ':
    return 1;
  default:
    break;
  }
  return 0;
}

int isupper(int c)
{
  if ((c >= 'A') && (c <= 'Z'))
    return 1;
  return 0;
}

int isxdigit(int c)
{
  if (isdigit(c) ||
      ((c >= 'A') && (c <= 'F')) || ((c >= 'a') && (c <= 'f')))
    return 1;
  return 0;
}

int tolower(int c)
{
  if (isupper(c))
    return c + ('a' - 'A');
  return c;
}

int toupper(int c)
{
  if (islower(c))
    return c - ('a' - 'A');
  return c;
}
