#if defined(__linux__)
#if defined(__m32r__)

/*
 * Use Linux system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4       114
#define SYS_kill         37
#define SYS_execve       11

#define SYS_read          3
#define SYS_write         4
#define SYS_open          5
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         63
#define SYS_pipe2       SYS_pipe /* Not exist (use pipe) */

#define SYS_sigaction   174 /* rt_sigaction */
#define SYS_sigprocmask 175 /* rt_sigprocmask */
#define SYS_sigreturn   173 /* rt_sigreturn */

#define SYS_getpid       20
#define SYS_getppid      64
#define SYS_getsid      147
#define SYS_setsid       66
#define SYS_getpgid     132
#define SYS_setpgid      57
#define SYS_getpgrp      65

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir      133
#define SYS_chmod        15
#define SYS_chown       212 /* chown32*/
#define SYS_lseek        19
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl       221 /* fcntl64 */
#define SYS_fsync       118
#define SYS_fchown      207 /* fchown32 */
#define SYS_fchmod       94
#define SYS_rename       38

#define SYS_mkdir        39
#define SYS_rmdir        40

#define SYS_mmap        192 /* mmap2 */
#define SYS_munmap       91

#define SYS_truncate     92
#define SYS_ftruncate    93

#define SYS_select      142 /* newselect */
#define SYS_pselect     308

#define SYS_gettimeofday 78
#define SYS_settimeofday 79

#define SYS_ioctl        54
#define SYS_brk          45
#define SYS_getdents    141
#define SYS_getcwd      183

	.section .text

	.globl	___exit
	.type	___exit, @function
___exit:
	ldi	r7, #SYS_exit
	trap	#0
	jmp	lr
	nop

	.globl	__fork
	.type	__fork, @function
__fork:
	ldi	r7, #SYS_fork
	trap	#0
	jmp	lr
	nop

	.globl	__wait4
	.type	__wait4, @function
__wait4:
	ldi	r7, #SYS_wait4
	trap	#0
	jmp	lr
	nop

	.globl	__kill
	.type	__kill, @function
__kill:
	ldi	r7, #SYS_kill
	trap	#0
	jmp	lr
	nop

	.globl	__execve
	.type	__execve, @function
__execve:
	ldi	r7, #SYS_execve
	trap	#0
	jmp	lr
	nop

	.globl	__read
	.type	__read, @function
__read:
	ldi	r7, #SYS_read
	trap	#0
	jmp	lr
	nop

	.globl	__write
	.type	__write, @function
__write:
	ldi	r7, #SYS_write
	trap	#0
	jmp	lr
	nop

	.globl	__open
	.type	__open, @function
__open:
	ldi	r7, #SYS_open
	trap	#0
	jmp	lr
	nop

	.globl	__close
	.type	__close, @function
__close:
	ldi	r7, #SYS_close
	trap	#0
	jmp	lr
	nop

	.globl	__dup
	.type	__dup, @function
__dup:
	ldi	r7, #SYS_dup
	trap	#0
	jmp	lr
	nop

	.globl	__pipe
	.type	__pipe, @function
__pipe:
	ldi	r7, #SYS_pipe
	trap	#0
	jmp	lr
	nop

	.globl	__dup2
	.type	__dup2, @function
__dup2:
	ldi	r7, #SYS_dup2
	trap	#0
	jmp	lr
	nop

	.globl	__pipe2
	.type	__pipe2, @function
__pipe2:
	ldi	r7, #SYS_pipe2
	trap	#0
	jmp	lr
	nop

	.globl	__sigaction
	.type	__sigaction, @function
__sigaction:
	ldi	r7, #SYS_sigaction
	trap	#0
	jmp	lr
	nop

	.globl	__sigprocmask
	.type	__sigprocmask, @function
__sigprocmask:
	ldi	r7, #SYS_sigprocmask
	trap	#0
	jmp	lr
	nop

	.globl	__sigreturn
	.type	__sigreturn, @function
__sigreturn:
	ldi	r7, #SYS_sigreturn
	trap	#0
	jmp	lr
	nop

	.globl	__getpid
	.type	__getpid, @function
__getpid:
	ldi	r7, #SYS_getpid
	trap	#0
	jmp	lr
	nop

	.globl	__getppid
	.type	__getppid, @function
__getppid:
	ldi	r7, #SYS_getppid
	trap	#0
	jmp	lr
	nop

	.globl	__getsid
	.type	__getsid, @function
__getsid:
	ldi	r7, #SYS_getsid
	trap	#0
	jmp	lr
	nop

	.globl	__setsid
	.type	__setsid, @function
__setsid:
	ldi	r7, #SYS_setsid
	trap	#0
	jmp	lr
	nop

	.globl	__getpgid
	.type	__getpgid, @function
__getpgid:
	ldi	r7, #SYS_getpgid
	trap	#0
	jmp	lr
	nop

	.globl	__setpgid
	.type	__setpgid, @function
__setpgid:
	ldi	r7, #SYS_setpgid
	trap	#0
	jmp	lr
	nop

	.globl	__getpgrp
	.type	__getpgrp, @function
__getpgrp:
	ldi	r7, #SYS_getpgrp
	trap	#0
	jmp	lr
	nop

	.globl	__unlink
	.type	__unlink, @function
__unlink:
	ldi	r7, #SYS_unlink
	trap	#0
	jmp	lr
	nop

	.globl	__chdir
	.type	__chdir, @function
__chdir:
	ldi	r7, #SYS_chdir
	trap	#0
	jmp	lr
	nop

	.globl	__fchdir
	.type	__fchdir, @function
__fchdir:
	ldi	r7, #SYS_fchdir
	trap	#0
	jmp	lr
	nop

	.globl	__chmod
	.type	__chmod, @function
__chmod:
	ldi	r7, #SYS_chmod
	trap	#0
	jmp	lr
	nop

	.globl	__chown
	.type	__chown, @function
__chown:
	ldi	r7, #SYS_chown
	trap	#0
	jmp	lr
	nop

	.globl	__lseek
	.type	__lseek, @function
__lseek:
	ldi	r7, #SYS_lseek
	trap	#0
	jmp	lr
	nop

	.globl	__access
	.type	__access, @function
__access:
	ldi	r7, #SYS_access
	trap	#0
	jmp	lr
	nop

	.globl	__sync
	.type	__sync, @function
__sync:
	ldi	r7, #SYS_sync
	trap	#0
	jmp	lr
	nop

	.globl	__fcntl
	.type	__fcntl, @function
__fcntl:
	ldi	r7, #SYS_fcntl
	trap	#0
	jmp	lr
	nop

	.globl	__fsync
	.type	__fsync, @function
__fsync:
	ldi	r7, #SYS_fsync
	trap	#0
	jmp	lr
	nop

	.globl	__fchown
	.type	__fchown, @function
__fchown:
	ldi	r7, #SYS_fchown
	trap	#0
	jmp	lr
	nop

	.globl	__fchmod
	.type	__fchmod, @function
__fchmod:
	ldi	r7, #SYS_fchmod
	trap	#0
	jmp	lr
	nop

	.globl	__rename
	.type	__rename, @function
__rename:
	ldi	r7, #SYS_rename
	trap	#0
	jmp	lr
	nop

	.globl	__mkdir
	.type	__mkdir, @function
__mkdir:
	ldi	r7, #SYS_mkdir
	trap	#0
	jmp	lr
	nop

	.globl	__rmdir
	.type	__rmdir, @function
__rmdir:
	ldi	r7, #SYS_rmdir
	trap	#0
	jmp	lr
	nop

	.globl	__mmap
	.type	__mmap, @function
__mmap:
	ldi	r7, #SYS_mmap
	trap	#0
	jmp	lr
	nop

	.globl	__munmap
	.type	__munmap, @function
__munmap:
	ldi	r7, #SYS_munmap
	trap	#0
	jmp	lr
	nop

	.globl	__truncate
	.type	__truncate, @function
__truncate:
	ldi	r7, #SYS_truncate
	trap	#0
	jmp	lr
	nop

	.globl	__ftruncate
	.type	__ftruncate, @function
__ftruncate:
	ldi	r7, #SYS_ftruncate
	trap	#0
	jmp	lr
	nop

	.globl	__select
	.type	__select, @function
__select:
	ldi	r7, #SYS_select
	trap	#0
	jmp	lr
	nop

	.globl	__pselect
	.type	__pselect, @function
__pselect:
	ldi	r7, #SYS_pselect
	trap	#0
	jmp	lr
	nop

	.globl	__gettimeofday
	.type	__gettimeofday, @function
__gettimeofday:
	ldi	r7, #SYS_gettimeofday
	trap	#0
	jmp	lr
	nop

	.globl	__settimeofday
	.type	__settimeofday, @function
__settimeofday:
	ldi	r7, #SYS_settimeofday
	trap	#0
	jmp	lr
	nop

	.globl	__ioctl
	.type	__ioctl, @function
__ioctl:
	ldi	r7, #SYS_ioctl
	trap	#0
	jmp	lr
	nop

	.globl	__brk
	.type	__brk, @function
__brk:
	ldi	r7, #SYS_brk
	trap	#0
	jmp	lr
	nop

	.globl	__getdents
	.type	__getdents, @function
__getdents:
	ldi	r7, #SYS_getdents
	trap	#0
	jmp	lr
	nop

	.globl	____getcwd
	.type	____getcwd, @function
____getcwd:
	ldi	r7, #SYS_getcwd
	trap	#0
	jmp	lr
	nop
#endif
#endif
