#ifndef __NLLIBC_SYS_IOCTL_H_INCLUDED__
#define __NLLIBC_SYS_IOCTL_H_INCLUDED__

int ioctl(int fd, unsigned long request, ...);

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)
#define TIOCGETA  0x402c7413
#define TIOCSETA  0x802c7414
#define TIOCSETAW 0x802c7415
#define TIOCSETAF 0x802c7416
#define TIOCGPGRP 0x40047477
#define TIOCSPGRP 0x80047476
#endif

#if defined(__linux__)
#if defined(__PPC__) || defined(__alpha__)
#define TCGETS  0x402c7413
#define TCSETS  0x802c7414
#define TCSETSW 0x802c7415
#define TCSETSF 0x802c7416
#elif defined(__mips__)
#define TCGETS  0x540d
#define TCSETS  0x540e
#define TCSETSW 0x540f
#define TCSETSF 0x5410
#elif defined(__sparc__)
#define TCGETS  0x40245408
#define TCSETS  0x80245409
#define TCSETSW 0x8024540a
#define TCSETSF 0x8024540b
#elif defined(__hppa__)
#define TCGETS  0x40245410
#define TCSETS  0x80245411
#define TCSETSW 0x80245412
#define TCSETSF 0x80245413
#else
#define TCGETS  0x5401
#define TCSETS  0x5402
#define TCSETSW 0x5403
#define TCSETSF 0x5404
#endif

#if defined(__alpha__) || defined(__mips__) || defined(__PPC__) || defined(__sh__)
#define TIOCGPGRP 0x40047477
#define TIOCSPGRP 0x80047476
#elif defined(__hppa__)
#define TIOCGPGRP 0x4004541e
#define TIOCSPGRP 0x8004541d
#elif defined(__sparc__)
#define TIOCGPGRP 0x40047483
#define TIOCSPGRP 0x80047482
#else
#define TIOCGPGRP 0x540f
#define TIOCSPGRP 0x5410
#endif

#endif

#endif
