#include <stdlib.h>
#include <errno.h>

#include <nllibc.h>

int main(int argc, char *argv[], char *envp[]);

#if defined(__FreeBSD__)
char **environ;
const char *__progname;

void nlcrt_start(int argc, char *argv[], char *envp[])
{
  const char *s;
  environ = envp;
  if ((argc > 0) && argv[0]) {
    __progname = argv[0];
    for (s = __progname; *s; s++) {
      if (*s == '/')
	__progname = s + 1;
    }
  } else {
    __progname = "";
  }

  errno = 0;

  exit(main(argc, argv, envp));
}
#endif

#if defined(__linux__)
void nlcrt_start(int argc, char *argv[], char *envp[])
{
  errno = 0;

  exit(main(argc, argv, envp));
}
#endif
