#ifndef __NLL_SOUND_H_INCLUDED__
#define __NLL_SOUND_H_INCLUDED__

typedef enum {
  SOUND_TYPE_UNKNOWN = 0,
  SOUND_TYPE_WAV,
  SOUND_TYPE_TEXT,

  SOUND_TYPE_NUM
} sound_type_t;

typedef struct sound *sound_t;

struct sound {
  int index;
  sound_type_t type;

  int samplefreq;
  int channels;
  int bits;
  int samplenum;

  unsigned int flags;

  FILE *fp;
  int offset;

  union {
    void *p;
    int8_t *b;
    int16_t *h;
    int32_t *w;
  } frames;
};

int sound_init(void);
int sound_done(void);
int sound_check(void);

int sound_get_index(sound_t sound);
sound_t sound_get_sound(int index);
int sound_destroy(sound_t sound);
sound_t sound_create(sound_type_t type, unsigned int flags);

int sound_ropen(sound_t sound, const char *filename);
int sound_wopen(sound_t sound, const char *filename,
		int samplefreq, int channels, int bits, int samplenum);
int sound_read(sound_t sound, short *frames, int num);
int sound_write(sound_t sound, short *frames, int num);
int sound_rclose(sound_t sound);
int sound_wclose(sound_t sound);

#endif
