#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "const.h"
#include "image.h"
#include "charset.h"

struct charsets charsets[] = {
#ifdef USE_GRAPHIC
  { NLL_G_FONT8X8  , &charset_font8x8    , NULL },
  { NLL_G_FONT16X16, &charset_font16x16  , NULL },
  { NLL_G_FONT5X5  , &charset_font5x5    , NULL },
  { NLL_G_CHARA    , &charset_character  , NULL },
  { NLL_G_CHARA2   , &charset_character_2, NULL },
  { NLL_G_CHARA3   , &charset_character_3, NULL },
#endif
  { 0, NULL, NULL }
};

int charsets_num = ((sizeof(charsets) / sizeof(*charsets)) - 1);
