#ifndef __NLL_AREA_H_INCLUDED__
#define __NLL_AREA_H_INCLUDED__

struct area {
  struct area *next;
  struct area *prev;
  int refcount;
  int size;
  int area_size;
};

int area_check(void);
int area_alloc(area_t *areap, int size);
int area_free(area_t area);
int area_init(void);
int area_get_size(area_t area);
char *area_get_buffer(area_t area);
int area_copy_area(area_t area, int offset, area_t _area, int _offset, int size);
int area_read(area_t area, int offset, char *buffer, int size);
int area_write(area_t area, int offset, char *buffer, int size);
int area_read_integer(area_t area, int offset, integer_t *integerp, int size);
int area_write_integer(area_t area, int offset, integer_t integer, int size);
int area_dump(FILE *fp, area_t area);

#endif
