#ifndef __NLTL_LLLLIB_H_INCLUDED__
#define __NLTL_LLLLIB_H_INCLUDED__

enum {
  LLL_ERRCODE_UNKNOWN          = -  1,

  LLL_ERRCODE_FILE_NOT_FOUND   = - 10,
  LLL_ERRCODE_LESS_MEMORY      = - 11,
  LLL_ERRCODE_LESS_ARGUMENT    = - 12,
  LLL_ERRCODE_UNKNOWN_COMMAND  = - 13,
  LLL_ERRCODE_UNKNOWN_OPERATOR = - 14,
  LLL_ERRCODE_INVALID_FORMAT   = - 15,
};

void lll_error_print(const char *filename, int line,
		     int errcode, const char *param, int num);

void lll_error_exit(const char *filename, int line,
		    int errcode, const char *param, int num);

#define LLL_ERRPRINT(r, param, num) \
	lll_error_print(__FILE__, __LINE__, r, param, num)

#define LLL_ERREXIT(r, param, num) \
	lll_error_exit(__FILE__, __LINE__, r, param, num)

void lll_finished_clear(void);
void lll_finish(void);
int lll_is_finished(void);

#endif
