#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/select.h>

#include <nllibc.h>

time_t time(time_t *tloc)
{
  struct timeval t;

  if (gettimeofday(&t, NULL) < 0)
    return (time_t)-1;

  if (*tloc)
    *tloc = t.tv_sec;

  return t.tv_sec;
}

unsigned int sleep(unsigned int seconds)
{
  struct timeval t;

  t.tv_sec  = seconds;
  t.tv_usec = 0;

  select(0, NULL, NULL, NULL, &t);

  return 0;
}

int usleep(useconds_t microseconds)
{
  struct timeval t;

  t.tv_sec  = 0;
  t.tv_usec = microseconds;

  select(0, NULL, NULL, NULL, &t);

  return 0;
}
