#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)
#if defined(__PPC__)

/*
 * Use FreeBSD/NetBSD system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4         7
#define SYS_kill         37
#define SYS_execve       59

#define SYS_read          3
#define SYS_write         4
#define SYS_open          5
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         90
#define SYS_pipe2       542

#define SYS_sigaction   416
#define SYS_sigprocmask 340 /* 48? */
#define SYS_sigreturn   417

#define SYS_getpid       20
#define SYS_getppid      39
#define SYS_getsid      310
#define SYS_setsid      147
#define SYS_getpgid     207
#define SYS_setpgid      82
#define SYS_getpgrp      81

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir       13
#define SYS_chmod        15
#define SYS_chown        16
#define SYS_lseek       478
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl        92
#define SYS_fsync        95
#define SYS_fchown      123
#define SYS_fchmod      124
#define SYS_rename      128

#define SYS_mkdir       136
#define SYS_rmdir       137

#define SYS_mmap        477
#define SYS_munmap       73

#define SYS_truncate    479
#define SYS_ftruncate   480

#define SYS_select       93
#define SYS_pselect     522

#define SYS_gettimeofday 116
#define SYS_settimeofday 122

#define SYS_ioctl        54
#define SYS_break        17
#define SYS_sbrk         69
#define SYS_getdents    272
#define SYS_getcwd      326

	.section .text

	.globl	___exit
	.type	___exit, @function
___exit:
	li	%r0, SYS_exit
	b	_syscall

	.globl	__fork
	.type	__fork, @function
__fork:
	li	%r0, SYS_fork
	b	_syscall

	.globl	__wait4
	.type	__wait4, @function
__wait4:
	li	%r0, SYS_wait4
	b	_syscall

	.globl	__kill
	.type	__kill, @function
__kill:
	li	%r0, SYS_kill
	b	_syscall

	.globl	__execve
	.type	__execve, @function
__execve:
	li	%r0, SYS_execve
	b	_syscall

	.globl	__read
	.type	__read, @function
__read:
	li	%r0, SYS_read
	b	_syscall

	.globl	__write
	.type	__write, @function
__write:
	li	%r0, SYS_write
	b	_syscall

	.globl	__open
	.type	__open, @function
__open:
	li	%r0, SYS_open
	b	_syscall

	.globl	__close
	.type	__close, @function
__close:
	li	%r0, SYS_close
	b	_syscall

	.globl	__dup
	.type	__dup, @function
__dup:
	li	%r0, SYS_dup
	b	_syscall

	.globl	__pipe
	.type	__pipe, @function
__pipe:
	li	%r0, SYS_pipe
	b	_syscall

	.globl	__dup2
	.type	__dup2, @function
__dup2:
	li	%r0, SYS_dup2
	b	_syscall

	.globl	__pipe2
	.type	__pipe2, @function
__pipe2:
	li	%r0, SYS_pipe2
	b	_syscall

	.globl	__sigaction
	.type	__sigaction, @function
__sigaction:
	li	%r0, SYS_sigaction
	b	_syscall

	.globl	__sigprocmask
	.type	__sigprocmask, @function
__sigprocmask:
	li	%r0, SYS_sigprocmask
	b	_syscall

	.globl	__sigreturn
	.type	__sigreturn, @function
__sigreturn:
	li	%r0, SYS_sigreturn
	b	_syscall

	.globl	__getpid
	.type	__getpid, @function
__getpid:
	li	%r0, SYS_getpid
	b	_syscall

	.globl	__getppid
	.type	__getppid, @function
__getppid:
	li	%r0, SYS_getppid
	b	_syscall

	.globl	__getsid
	.type	__getsid, @function
__getsid:
	li	%r0, SYS_getsid
	b	_syscall

	.globl	__setsid
	.type	__setsid, @function
__setsid:
	li	%r0, SYS_setsid
	b	_syscall

	.globl	__getpgid
	.type	__getpgid, @function
__getpgid:
	li	%r0, SYS_getpgid
	b	_syscall

	.globl	__setpgid
	.type	__setpgid, @function
__setpgid:
	li	%r0, SYS_setpgid
	b	_syscall

	.globl	__getpgrp
	.type	__getpgrp, @function
__getpgrp:
	li	%r0, SYS_getpgrp
	b	_syscall

	.globl	__unlink
	.type	__unlink, @function
__unlink:
	li	%r0, SYS_unlink
	b	_syscall

	.globl	__chdir
	.type	__chdir, @function
__chdir:
	li	%r0, SYS_chdir
	b	_syscall

	.globl	__fchdir
	.type	__fchdir, @function
__fchdir:
	li	%r0, SYS_fchdir
	b	_syscall

	.globl	__chmod
	.type	__chmod, @function
__chmod:
	li	%r0, SYS_chmod
	b	_syscall

	.globl	__chown
	.type	__chown, @function
__chown:
	li	%r0, SYS_chown
	b	_syscall

	.globl	__lseek
	.type	__lseek, @function
__lseek:
	li	%r0, SYS_lseek
	b	_syscall

	.globl	__access
	.type	__access, @function
__access:
	li	%r0, SYS_access
	b	_syscall

	.globl	__sync
	.type	__sync, @function
__sync:
	li	%r0, SYS_sync
	b	_syscall

	.globl	__fcntl
	.type	__fcntl, @function
__fcntl:
	li	%r0, SYS_fcntl
	b	_syscall

	.globl	__fsync
	.type	__fsync, @function
__fsync:
	li	%r0, SYS_fsync
	b	_syscall

	.globl	__fchown
	.type	__fchown, @function
__fchown:
	li	%r0, SYS_fchown
	b	_syscall

	.globl	__fchmod
	.type	__fchmod, @function
__fchmod:
	li	%r0, SYS_fchmod
	b	_syscall

	.globl	__rename
	.type	__rename, @function
__rename:
	li	%r0, SYS_rename
	b	_syscall

	.globl	__mkdir
	.type	__mkdir, @function
__mkdir:
	li	%r0, SYS_mkdir
	b	_syscall

	.globl	__rmdir
	.type	__rmdir, @function
__rmdir:
	li	%r0, SYS_rmdir
	b	_syscall

	.globl	__mmap
	.type	__mmap, @function
__mmap:
	li	%r0, SYS_mmap
	b	_syscall

	.globl	__munmap
	.type	__munmap, @function
__munmap:
	li	%r0, SYS_munmap
	b	_syscall

	.globl	__truncate
	.type	__truncate, @function
__truncate:
	li	%r0, SYS_truncate
	b	_syscall

	.globl	__ftruncate
	.type	__ftruncate, @function
__ftruncate:
	li	%r0, SYS_ftruncate
	b	_syscall

	.globl	__select
	.type	__select, @function
__select:
	li	%r0, SYS_select
	b	_syscall

	.globl	__pselect
	.type	__pselect, @function
__pselect:
	li	%r0, SYS_pselect
	b	_syscall

	.globl	__gettimeofday
	.type	__gettimeofday, @function
__gettimeofday:
	li	%r0, SYS_gettimeofday
	b	_syscall

	.globl	__settimeofday
	.type	__settimeofday, @function
__settimeofday:
	li	%r0, SYS_settimeofday
	b	_syscall

	.globl	__ioctl
	.type	__ioctl, @function
__ioctl:
	li	%r0, SYS_ioctl
	b	_syscall

	.globl	__break
	.type	__break, @function
__break:
	li	%r0, SYS_break
	b	_syscall

	.globl	__sbrk
	.type	__sbrk, @function
__sbrk:
	li	%r0, SYS_sbrk
	b	_syscall

	.globl	__getdents
	.type	__getdents, @function
__getdents:
	li	%r0, SYS_getdents
	b	_syscall

	.globl	____getcwd
	.type	____getcwd, @function
____getcwd:
	li	%r0, SYS_getcwd
	b	_syscall

_syscall:
	sc
	bc	12, 3, err
	b	ret
err:	stwu	%r1, -16(%r1)
	mflr	%r0
	stw	%r0, 20(%r1)
	bl	_set_errno
	lwz	%r0, 20(%r1)
	addi	%r1, %r1, 16
	mtlr	%r0
ret:	blr
#endif
#endif
