#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "const.h"
#include "image.h"
#include "charset.h"

#define CHARACTER_SIZE 64

#define TP 0x80 /* transparent */

#define B_   (1 << 0)
#define B__  (2 << 0)
#define B___ (3 << 0)
#define G_   (1 << 2)
#define G__  (2 << 2)
#define G___ (3 << 2)
#define R_   (1 << 4)
#define R__  (2 << 4)
#define R___ (3 << 4)

#define BK 0x00 /* black */

#define BL (          B___) /* blue */
#define GR (     G___     ) /* green */
#define CY (     G___|B___) /* cyan */
#define RD (R___          ) /* red */
#define MG (R___     |B___) /* magenta */
#define YL (R___|G___     ) /* yellow */
#define WH (R___|G___|B___) /* white */

#define B0 (        B_ )
#define B1 (        B__)
#define G0 (    G_     )
#define G1 (    G__    )
#define C0 (    G_ |B_ )
#define C1 (    G__|B__)
#define R0 (R_         )
#define R1 (R__        )
#define M0 (R_     |B_ )
#define M1 (R__    |B__)
#define Y0 (R_ |G_     )
#define Y1 (R__|G__    )
#define W0 (R_ |G_ |B_ )
#define W1 (R__|G__|B__)

#define C2 (     G_  |B__ )
#define C3 (     G_  |B___)
#define C4 (     G__ |B_  )
#define C5 (     G__ |B___)
#define C6 (     G___|B_  )
#define C7 (     G___|B__ )
#define M2 (R_       |B__ )
#define M3 (R_       |B___)
#define M4 (R__      |B_  )
#define M5 (R__      |B___)
#define M6 (R___     |B_  )
#define M7 (R___     |B__ )
#define Y2 (R_  |G__      )
#define Y3 (R_  |G___     )
#define Y4 (R__ |G_       )
#define Y5 (R__ |G___     )
#define Y6 (R___|G_       )
#define Y7 (R___|G__      )

#define Z0 (R_  |G_  |B__ )
#define Z1 (R_  |G_  |B___)
#define Z2 (R_  |G__ |B_  )
#define Z3 (R_  |G__ |B__ )
#define Z4 (R_  |G__ |B___)
#define Z5 (R_  |G___|B_  )
#define Z6 (R_  |G___|B__ )
#define Z7 (R_  |G___|B___)
#define Z8 (R__ |G_  |B_  )
#define Z9 (R__ |G_  |B__ )
#define ZA (R__ |G_  |B___)
#define ZB (R__ |G__ |B_  )
#define ZC (R__ |G__ |B___)
#define ZD (R__ |G___|B_  )
#define ZE (R__ |G___|B__ )
#define ZF (R__ |G___|B___)
#define ZG (R___|G_  |B_  )
#define ZH (R___|G_  |B__ )
#define ZI (R___|G_  |B___)
#define ZJ (R___|G__ |B_  )
#define ZK (R___|G__ |B__ )
#define ZL (R___|G__ |B___)
#define ZM (R___|G___|B_  )
#define ZN (R___|G___|B__ )

#ifdef USE_GRAPHIC
static GRAPHIC_CHARACTER_PRESET_TYPE unsigned char bitmap[] = {
  /* nijimasu kun */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,

  /* nijimasu kun (huu) */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,

  /* nijimasu kun (x) */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,WH,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,

  /* nijimasu kun (pun) */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,WH,WH,WH,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,

  /* punin kun */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,BK,BK,BK,ZN,BK,BK,BK,BK,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,BK,BK,ZN,ZN,BK,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZH,ZH,ZH,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZH,ZH,ZH,ZH,ZH,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,WH,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZH,ZH,ZH,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,M7,RD,RD,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,M7,M7,M7,RD,RD,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZH,ZH,ZH,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,M7,M7,M7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZH,ZH,ZH,ZH,ZH,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZH,ZH,ZH,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,G0,G0,G0,G0,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,BK,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,TP,BK,BK,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,BK,BK,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,G0,G0,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,G0,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,G0,G0,G1,G0,G1,G0,G1,G0,G1,G0,G1,G0,G1,G0,G1,G0,G1,G0,G1,G0,BK,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,G0,G1,G0,G1,G0,G1,G0,G1,G0,G1,G0,G1,G0,G1,G0,G1,G0,G1,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,G0,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,R0,R0,R0,R0,W0,W0,W0,W0,R0,R0,R0,R0,R0,R0,R0,G0,G0,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,G1,R0,G1,R0,G1,R0,G1,W0,G1,BK,BK,BK,R0,G1,R0,G1,R0,G1,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,R0,R0,R0,R0,R0,R0,R0,W0,W0,W0,W0,R0,R0,R0,R0,R0,R0,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,B0,B0,B0,B0,B0,B0,BK,BK,BK,BK,B0,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,B0,B0,BK,TP,TP,TP,BK,B0,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,BK,TP,TP,TP,TP,BK,R0,R0,R0,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* punitaro */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,WH,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZH,ZH,ZH,ZN,BK,RD,RD,RD,BK,ZN,ZN,ZH,ZH,ZH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZH,ZH,ZH,ZN,BK,ZH,ZH,ZH,BK,ZN,ZN,ZH,ZH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZH,ZH,ZH,ZH,ZH,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,G1,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,G1,GR,GR,GR,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,GR,G1,G1,BK,GR,GR,GR,GR,GR,G1,GR,GR,G1,G1,GR,GR,GR,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,GR,BK,GR,GR,GR,GR,GR,GR,G1,G1,GR,GR,G1,GR,GR,GR,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,GR,GR,GR,GR,GR,GR,GR,G1,GR,GR,G1,GR,GR,GR,GR,GR,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,GR,GR,BK,BK,BK,GR,W0,GR,GR,W0,GR,GR,GR,GR,GR,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,GR,GR,BK,ZN,ZN,BK,GR,G1,GR,GR,G1,GR,GR,GR,GR,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,GR,GR,GR,ZN,BK,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,GR,GR,GR,GR,BK,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,GR,GR,GR,GR,BK,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,W0,W0,W0,W0,W0,W0,W0,W0,C0,C0,BK,C0,C0,W0,W0,W0,W0,W0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,W0,W0,W0,W0,W0,W0,W0,C0,W0,C0,C0,C0,W0,C0,W0,W0,W0,W0,W0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,W0,W0,W0,W0,W0,W0,W0,W0,W0,C0,C0,W0,C0,C0,W0,W0,W0,W0,W0,W0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,C0,W0,C0,W0,W0,W0,W0,W0,W0,W0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,W0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,W0,W0,W0,W0,W0,W0,W0,BK,BK,BK,BK,BK,BK,W0,W0,W0,W0,W0,W0,W0,W0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,W0,W0,W0,W0,BK,TP,TP,TP,TP,TP,TP,BK,W0,W0,W0,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,W0,W0,W0,BK,TP,TP,TP,TP,TP,TP,BK,W0,W0,W0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,C0,C0,C0,B0,BK,TP,TP,TP,TP,TP,BK,C0,C0,C0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,C0,C0,C0,C0,C0,B0,BK,TP,TP,TP,BK,C0,C0,C0,C0,C0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,C0,C0,C0,C0,C0,C0,BK,TP,TP,TP,BK,C0,C0,C0,C0,C0,C0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* kawaii chan */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,WH,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZB,WH,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,WH,WH,WH,WH,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,BK,WH,WH,WH,WH,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,WH,WH,WH,BK,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,BK,BK,WH,BK,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,BK,WH,WH,BK,WH,BK,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,BK,WH,WH,WH,WH,BK,BK,WH,WH,WH,WH,BK,WH,WH,WH,WH,BK,WH,BK,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,BK,BK,BK,BK,WH,WH,WH,WH,BK,WH,BK,BK,BK,BK,BK,WH,WH,BK,WH,BK,WH,WH,WH,WH,BK,WH,WH,WH,BK,BK,BK,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,BK,BK,BK,BK,BK,BK,WH,WH,WH,BK,WH,WH,WH,WH,BK,BK,BK,BK,WH,WH,BK,WH,WH,WH,WH,BK,BK,BK,BK,WH,BK,WH,WH,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,BK,BK,BK,BK,BK,BK,WH,WH,WH,BK,WH,WH,WH,WH,BK,BK,BK,WH,BK,WH,BK,WH,WH,WH,WH,BK,BK,WH,BK,WH,BK,WH,WH,WH,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,BK,BK,BK,BK,BK,WH,WH,WH,WH,BK,WH,WH,WH,WH,BK,BK,WH,WH,WH,BK,BK,WH,WH,WH,WH,BK,WH,WH,WH,BK,BK,WH,WH,WH,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,BK,BK,WH,WH,WH,BK,BK,WH,WH,WH,WH,BK,WH,WH,WH,BK,BK,WH,WH,WH,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,BK,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,BK,BK,BK,BK,BK,BK,WH,WH,WH,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,BK,WH,WH,WH,BK,BK,WH,WH,WH,WH,BK,BK,WH,WH,WH,BK,WH,WH,WH,BK,TP,TP,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,BK,BK,WH,WH,BK,BK,WH,WH,WH,WH,WH,BK,BK,WH,WH,BK,WH,WH,WH,BK,TP,TP,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,BK,BK,BK,WH,BK,WH,WH,WH,WH,WH,BK,BK,BK,BK,BK,WH,WH,WH,BK,TP,TP,TP,BK,BK,BK,RD,RD,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,WH,WH,WH,WH,BK,TP,TP,TP,BK,BK,RD,RD,BK,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,BK,BK,RD,RD,BK,BK,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,RD,RD,RD,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,RD,RD,BK,BK,BK,BK,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,RD,RD,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,RD,RD,BK,BK,BK,BK,BK,BK,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,ZH,ZH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,ZH,ZH,WH,WH,BK,TP,TP,TP,TP,BK,BK,BK,TP,BK,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,ZH,ZH,ZH,ZH,WH,WH,WH,WH,RD,RD,WH,WH,RD,RD,WH,WH,WH,ZH,ZH,ZH,ZH,WH,BK,TP,TP,TP,BK,BK,BK,BK,TP,BK,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,BK,BK,BK,BK,BK,TP,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,ZH,ZH,ZH,ZH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,RD,WH,WH,ZH,ZH,ZH,ZH,WH,BK,TP,TP,TP,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,BK,BK,BK,TP,TP,BK,BK,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,ZH,ZH,WH,WH,WH,WH,R0,R0,R0,R0,R0,R0,R0,R0,WH,WH,WH,ZH,ZH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,TP,BK,BK,BK,BK,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,TP,TP,TP,BK,BK,BK,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,RD,RD,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,WH,WH,WH,WH,WH,RD,RD,WH,WH,WH,RD,RD,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,RD,RD,RD,RD,RD,RD,RD,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,RD,RD,CY,CY,CY,RD,RD,CY,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,CY,CY,CY,CY,CY,CY,CY,CY,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,CY,CY,CY,CY,YL,CY,CY,CY,CY,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,CY,CY,CY,CY,CY,CY,CY,CY,CY,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,CY,CY,CY,CY,CY,CY,CY,CY,CY,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,CY,CY,CY,CY,CY,YL,CY,CY,BK,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,CY,CY,CY,CY,CY,CY,CY,CY,BK,BK,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,BK,CY,CY,CY,CY,CY,CY,CY,BK,TP,BK,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,BK,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,BK,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,BK,BK,GR,GR,G1,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,TP,GR,GR,GR,G1,GR,G1,GR,GR,G1,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,G1,GR,GR,G1,GR,GR,G1,G1,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,GR,GR,GR,GR,GR,G1,G1,GR,GR,GR,G1,G1,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,BK,TP,BK,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,BK,TP,TP,BK,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,BK,BK,TP,TP,TP,BK,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,TP,TP,TP,TP,TP,BK,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* marui kun */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,ZN,BK,ZN,BK,ZN,BK,ZN,BK,ZN,BK,ZN,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,BK,ZN,BK,ZN,BK,ZN,ZN,BK,ZN,ZN,BK,ZN,BK,ZN,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,BK,ZN,BK,ZN,ZN,BK,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,BK,ZN,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,BK,ZN,BK,ZN,ZN,BK,ZN,ZN,BK,ZN,ZN,ZN,ZN,BK,ZN,ZN,BK,ZN,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,BK,ZN,BK,ZN,ZN,BK,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,BK,ZN,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,BK,BK,ZN,BK,ZN,ZN,BK,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,BK,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,BK,ZN,ZN,BK,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,BK,WH,WH,BK,WH,WH,WH,BK,BK,BK,ZN,ZN,ZN,BK,WH,WH,BK,WH,WH,WH,BK,BK,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,BK,WH,WH,WH,WH,BK,WH,BK,WH,WH,WH,BK,ZN,BK,WH,WH,WH,WH,BK,WH,BK,WH,WH,WH,BK,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,BK,BK,WH,WH,BK,WH,WH,BK,BK,WH,WH,BK,ZN,BK,BK,WH,WH,BK,WH,WH,BK,BK,WH,WH,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,BK,BK,BK,BK,WH,BK,BK,WH,BK,BK,WH,BK,ZN,BK,BK,BK,BK,WH,BK,BK,WH,BK,BK,WH,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,BK,WH,WH,BK,WH,WH,BK,WH,BK,BK,ZN,ZN,ZN,BK,WH,WH,BK,WH,WH,BK,WH,BK,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,M7,M7,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,M7,M7,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,M7,ZH,ZH,M7,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,M7,ZH,ZH,M7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,M7,ZH,ZH,M7,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,M7,ZH,ZH,M7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,M7,M7,ZN,ZN,BK,WH,WH,WH,WH,WH,BK,BK,ZN,ZN,ZN,ZN,ZN,M7,M7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,RD,RD,RD,RD,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,M7,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,Y0,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,WH,WH,BK,ZF,ZF,ZF,ZF,ZF,BK,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,WH,WH,WH,WH,BK,ZF,ZF,ZF,ZF,ZF,BK,WH,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,CY,CY,BK,BK,WH,WH,WH,WH,BK,ZF,ZF,ZF,BK,WH,WH,WH,WH,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,CY,CY,CY,WH,CY,CY,BK,BK,WH,WH,BK,ZF,ZF,ZF,BK,WH,WH,WH,BK,BK,CY,CY,CY,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,CY,WH,CY,CY,CY,CY,CY,BK,BK,WH,BK,ZF,ZF,ZF,BK,WH,WH,BK,BK,CY,CY,WH,CY,CY,WH,CY,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,CY,CY,CY,CY,WH,CY,BK,BK,WH,WH,WH,WH,BK,ZF,BK,WH,WH,WH,WH,WH,BK,CY,CY,CY,CY,CY,CY,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,WH,BK,CY,WH,CY,CY,CY,CY,CY,BK,BK,WH,WH,WH,BK,ZF,BK,WH,WH,WH,WH,WH,BK,BK,CY,CY,CY,CY,BK,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,BK,CY,CY,CY,BK,CY,CY,WH,CY,CY,BK,BL,BL,BL,ZF,BL,BL,BL,BK,BK,BK,BK,CY,CY,WH,CY,CY,BK,WH,WH,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,WH,BK,CY,CY,CY,BK,CY,CY,CY,CY,CY,CY,BL,BL,BL,B0,BL,BL,BL,CY,CY,CY,CY,CY,BK,CY,CY,BK,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,TP,BK,BK,BK,BK,CY,WH,CY,CY,CY,CY,BL,BL,BL,B0,BL,BL,BL,CY,WH,CY,CY,CY,BK,BK,BK,BK,BK,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,CY,CY,CY,WH,CY,BL,BL,BL,C2,BL,BL,BL,CY,CY,CY,CY,BK,TP,TP,TP,TP,BK,BK,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,CY,CY,CY,CY,CY,CY,CY,C2,C2,C2,CY,WH,CY,CY,WH,CY,BK,TP,TP,TP,TP,TP,TP,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,CY,CY,CY,CY,WH,CY,C2,C2,CY,C2,C2,CY,CY,CY,CY,CY,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,CY,CY,WH,CY,CY,CY,CY,BL,WH,CY,CY,WH,CY,CY,CY,CY,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,WH,CY,CY,CY,CY,WH,CY,BL,CY,Y0,CY,CY,CY,WH,CY,CY,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,CY,CY,CY,CY,CY,CY,CY,CY,BL,CY,CY,WH,CY,CY,CY,CY,CY,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,B0,B0,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,B0,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,BK,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,BK,B0,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,B0,B0,B0,B0,B0,B0,B0,B0,B0,B0,BK,BK,BK,B0,B0,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,B0,B0,B0,BK,BK,TP,TP,BK,B0,B0,B0,B0,B0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,BK,BK,BK,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,W0,BK,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,W0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,W0,BK,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,W0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* onigiri kun */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,BK,BK,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,BK,BK,WH,BK,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,BK,WH,BK,WH,BK,BK,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,BK,WH,WH,BK,WH,BK,WH,BK,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,BK,BK,BK,BK,BK,BK,BK,WH,WH,WH,BK,BK,BK,BK,BK,BK,BK,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,BK,WH,BK,WH,WH,BK,WH,WH,BK,WH,BK,WH,BK,WH,WH,BK,WH,WH,BK,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,BK,WH,WH,BK,BK,WH,BK,WH,BK,WH,BK,WH,WH,BK,BK,WH,BK,WH,BK,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,BK,BK,BK,BK,BK,BK,BK,WH,WH,WH,BK,BK,BK,BK,BK,BK,BK,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,M7,M7,M7,WH,WH,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,WH,WH,M7,M7,M7,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,M7,ZH,ZH,ZH,M7,WH,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,WH,M7,ZH,ZH,ZH,M7,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,M7,ZH,ZH,ZH,M7,WH,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,WH,M7,ZH,ZH,ZH,M7,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,M7,M7,M7,WH,WH,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,WH,WH,M7,M7,M7,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,WH,WH,WH,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,WH,WH,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,BK,WH,WH,BK,BK,BK,BK,WH,WH,BK,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,BK,BK,WH,WH,BK,BK,BK,BK,WH,WH,BK,BK,WH,WH,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,WH,BK,BK,BK,WH,WH,BK,BK,WH,WH,BK,BK,BK,WH,WH,BK,R1,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,BK,WH,WH,WH,WH,BK,WH,WH,WH,WH,WH,WH,BK,WH,WH,WH,WH,BK,WH,WH,R1,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,M0,WH,WH,BK,BK,WH,BK,WH,BK,BK,WH,WH,WH,WH,BK,BK,WH,BK,WH,BK,R1,WH,WH,WH,WH,R1,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,M0,WH,M0,BK,WH,BK,WH,WH,BK,BK,WH,WH,WH,WH,BK,BK,WH,WH,BK,WH,WH,WH,R1,WH,WH,WH,WH,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,WH,M0,BK,BK,WH,WH,WH,BK,BK,WH,WH,WH,WH,BK,BK,WH,WH,WH,BK,R1,WH,WH,WH,R1,WH,WH,BK,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,BK,WH,WH,WH,BK,WH,BK,BK,BK,W1,W1,ZK,BK,ZK,W1,W1,BK,BK,BK,BK,WH,BK,WH,WH,WH,WH,WH,R1,BK,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,BK,WH,M0,WH,BK,ZK,ZK,WH,WH,W1,W1,ZK,W1,ZK,W1,W1,WH,WH,WH,WH,WH,G0,BK,WH,R1,WH,WH,BK,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,BK,WH,M0,WH,BK,ZK,ZK,WH,WH,W1,W1,ZK,W1,ZK,W1,W1,G0,WH,WH,WH,WH,G0,BK,BK,WH,WH,R1,BK,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,BK,BK,WH,WH,BK,WH,WH,WH,WH,W1,W1,ZJ,ZJ,ZJ,W1,W1,G0,WH,WH,G0,WH,WH,BK,BK,BK,BK,BK,TP,BK,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,BK,WH,BK,BK,TP,BK,BK,BK,BK,WH,WH,WH,WH,WH,ZJ,ZJ,BK,ZJ,ZJ,WH,WH,WH,WH,G0,WH,WH,BK,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,TP,BK,TP,TP,TP,TP,TP,TP,BK,WH,ZK,ZK,ZK,WH,WH,WH,BK,WH,RD,WH,WH,G0,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,BK,BK,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,ZK,ZK,WH,WH,WH,BK,WH,WH,WH,WH,G0,WH,WH,G0,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,WH,ZK,ZK,BK,WH,RD,G0,WH,WH,WH,WH,G0,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,ZK,ZK,WH,WH,ZK,ZK,BK,WH,WH,G0,WH,WH,WH,WH,WH,WH,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,BK,R0,R0,R0,R0,R0,R0,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,BK,R0,R0,R0,R0,R0,R0,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,BK,R0,R0,R0,R0,R0,R0,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,BK,BK,BK,R0,R0,R0,R0,R0,R0,R0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,R0,R0,R0,R0,R0,R0,R0,R0,R0,R0,BK,TP,BK,R0,R0,R0,R0,R0,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,BK,BK,BK,BK,BK,G0,G0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,YL,Y7,YL,G0,G0,G0,G0,G0,BK,TP,TP,TP,TP,TP,YL,Y7,YL,G0,G0,G0,G0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,YL,Y7,YL,G0,G0,G0,G0,G0,G0,BK,TP,TP,TP,TP,YL,Y7,YL,G0,G0,G0,G0,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,Y7,BK,Y7,G0,G0,G0,G0,BK,BK,BK,TP,TP,TP,TP,Y7,BK,Y7,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* shikakui chan */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,ZN,ZN,BK,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,BK,ZN,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,ZN,BK,ZN,ZN,BK,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,BK,ZN,BK,Y7,Y7,Y7,Y7,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,BK,ZN,BK,ZN,ZN,BK,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,BK,ZN,BK,Y7,Y7,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,Y7,BK,ZN,BK,ZN,ZN,BK,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,BK,ZN,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,Y7,BK,ZN,BK,ZN,ZN,BK,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,Y7,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,Y7,Y7,BK,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,Y7,Y7,BK,ZN,BK,WH,BK,WH,BK,WH,BK,WH,WH,BK,ZN,ZN,BK,WH,BK,WH,BK,WH,BK,WH,WH,BK,ZN,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,Y7,Y7,BK,ZN,BK,WH,WH,BK,WH,WH,WH,BK,WH,BK,ZN,ZN,BK,WH,WH,BK,WH,WH,WH,BK,WH,BK,ZN,BK,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,Y7,Y7,BK,ZN,BK,BK,BK,WH,BK,WH,BK,WH,BK,BK,ZN,ZN,BK,BK,BK,WH,BK,WH,BK,WH,BK,BK,ZN,BK,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,BK,Y7,Y7,BK,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,BK,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,BK,Y7,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,Y7,Y7,Y7,BK,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,BK,Y7,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,Y7,Y7,Y7,BK,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,BK,Y7,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,Y7,Y7,Y7,BK,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,BK,Y7,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,Y7,Y7,BK,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,BK,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,Y7,Y7,Y7,BK,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,BK,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,RD,RD,RD,RD,RD,RD,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,Y7,Y7,Y7,BK,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,BK,Y7,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,RD,RD,RD,RD,RD,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,Y7,Y7,Y7,Y7,BK,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,BK,Y7,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,RD,RD,RD,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,Y7,Y7,Y7,BK,BK,Y7,Y7,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,Y7,Y7,Y7,Y7,Y7,Y7,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,TP,BK,Y7,Y7,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,Y7,Y7,Y7,Y7,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,RD,RD,BK,TP,TP,TP,TP,TP,TP,BK,R0,BK,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,WH,BK,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,BK,BK,ZN,ZN,ZN,ZN,BK,WH,WH,BK,BK,RD,RD,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,BK,WH,BK,ZN,ZN,ZN,ZN,BK,WH,WH,WH,WH,BK,RD,RD,RD,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,RD,RD,BK,WH,WH,WH,BK,ZN,ZN,ZN,BK,WH,WH,BK,BK,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,RD,RD,RD,BK,WH,WH,WH,WH,BK,ZN,ZN,BK,WH,WH,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,BK,BK,WH,WH,BK,ZN,ZN,BK,WH,WH,WH,BK,RD,RD,RD,RD,RD,RD,RD,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,WH,WH,BK,ZN,BK,WH,WH,WH,WH,BK,RD,RD,RD,RD,RD,RD,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,RD,RD,RD,RD,RD,RD,RD,RD,BK,WH,WH,WH,BK,ZN,BK,WH,WH,WH,BK,RD,RD,RD,RD,RD,RD,RD,BK,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,BK,RD,RD,RD,RD,RD,RD,RD,RD,BK,BK,WH,WH,BK,WH,WH,WH,BK,RD,RD,RD,RD,RD,RD,RD,BK,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,WH,BK,WH,BK,BK,RD,RD,RD,RD,RD,BK,BK,RD,BK,BK,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,BK,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,RD,BK,BK,BK,RD,RD,RD,RD,RD,RD,RD,BK,TP,BK,BK,TP,BK,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,BK,BK,TP,BK,BK,BK,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,YL,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,BK,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,BK,YL,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,BK,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,BK,YL,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,BK,YL,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,BK,YL,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,YL,YL,BK,YL,YL,YL,YL,BK,YL,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,YL,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

#ifndef GRAPHIC_CHARACTER_PRESET_LIMITED
  /* super butterfly */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,BK,ZN,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,BK,BK,ZN,BK,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,TP,TP,TP,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,WH,BK,WH,BK,BK,ZN,ZN,BK,BK,BK,WH,BK,WH,WH,WH,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,BK,BK,WH,WH,BK,BK,BK,BK,BK,WH,BK,ZN,BK,BK,WH,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,WH,BK,BK,BK,BK,BK,WH,WH,WH,BK,ZN,BK,BK,BK,WH,WH,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,WH,WH,WH,WH,BK,BK,BK,BK,ZN,ZN,ZN,BK,BK,BK,BK,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,RD,BK,ZN,ZN,BK,BK,RD,RD,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,BK,BK,ZN,ZN,BK,RD,BK,BK,RD,RD,BK,ZN,ZN,BK,RD,RD,RD,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,BK,ZN,BK,RD,RD,BK,ZN,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,BK,BK,RD,BK,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,RD,RD,RD,RD,RD,BK,BK,BK,BK,BK,TP,BK,ZN,BK,RD,RD,BK,ZN,ZN,BK,BK,RD,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,RD,BK,BK,BK,BK,RD,RD,RD,RD,RD,RD,RD,BK,BK,BK,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,MG,MG,BK,BK,RD,RD,RD,RD,RD,RD,RD,BK,BK,BK,RD,RD,RD,RD,RD,RD,BK,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,BK,RD,RD,RD,BK,BK,RD,RD,RD,RD,BK,BK,BK,RD,RD,RD,RD,RD,RD,BK,ZN,ZN,ZN,R0,BK,BK,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,BK,RD,RD,RD,RD,RD,BK,CY,CY,CY,BK,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,
  TP,TP,TP,TP,BK,RD,RD,BK,YL,YL,BK,RD,RD,BK,BL,BL,BL,BK,RD,RD,RD,RD,RD,RD,BK,BK,BK,RD,RD,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,RD,RD,RD,BK,CY,CY,CY,CY,BK,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,
  TP,TP,TP,BK,RD,RD,BK,YL,YL,YL,YL,BK,RD,BK,BL,BL,BL,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,BK,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,RD,RD,BK,CY,CY,CY,CY,BK,RD,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,
  TP,TP,TP,BK,RD,RD,BK,YL,YL,YL,YL,BK,RD,BK,BL,BL,BL,BK,RD,RD,RD,RD,RD,RD,RD,BK,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,RD,RD,BK,CY,CY,BK,RD,RD,RD,RD,RD,BK,BK,RD,RD,BK,TP,TP,
  TP,TP,TP,BK,RD,RD,BK,YL,YL,YL,BK,RD,RD,BK,BL,BL,BL,BK,RD,RD,RD,RD,RD,RD,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,RD,RD,BK,BK,RD,RD,RD,RD,RD,BK,GR,GR,BK,RD,RD,BK,TP,
  TP,TP,TP,BK,RD,RD,BK,YL,YL,YL,BK,RD,RD,RD,BK,BK,BK,RD,RD,RD,RD,RD,RD,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,RD,RD,RD,RD,RD,RD,RD,RD,BK,GR,GR,GR,GR,BK,RD,BK,TP,
  TP,TP,TP,R0,RD,RD,RD,BK,BK,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,RD,RD,RD,RD,RD,RD,RD,BK,GR,GR,GR,GR,BK,RD,BK,TP,
  TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,BK,MG,MG,MG,MG,BK,RD,RD,RD,RD,RD,RD,RD,BK,GR,GR,BK,BK,RD,RD,BK,TP,
  TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,BK,MG,MG,MG,MG,MG,BK,BK,BK,BK,BK,BK,YL,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,YL,BK,MG,MG,MG,MG,BK,RD,RD,RD,RD,RD,RD,RD,BK,BK,RD,RD,RD,RD,BK,TP,
  TP,TP,TP,TP,TP,TP,BK,BK,BK,RD,RD,RD,BK,BK,BK,BK,BK,MG,MG,MG,MG,MG,BK,BK,BK,YL,YL,YL,YL,YL,YL,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,YL,YL,BK,MG,MG,MG,MG,BK,R0,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,YL,YL,YL,BK,MG,MG,MG,BK,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,YL,YL,YL,YL,BK,MG,MG,BK,TP,TP,BK,RD,RD,RD,RD,RD,BK,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,BK,BK,BK,YL,YL,YL,YL,YL,YL,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,YL,YL,YL,YL,BK,MG,MG,MG,BK,TP,TP,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,BK,BK,GR,GR,BK,YL,YL,YL,YL,YL,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,YL,YL,YL,YL,YL,BK,MG,MG,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,BK,BK,GR,GR,GR,GR,BK,YL,YL,YL,YL,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,YL,YL,YL,YL,YL,YL,BK,MG,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,BK,GR,GR,GR,GR,GR,BK,YL,YL,YL,YL,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,YL,YL,YL,YL,YL,YL,YL,YL,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,BK,GR,GR,GR,GR,GR,BK,YL,YL,YL,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,BK,GR,GR,GR,GR,BK,BK,YL,YL,YL,BK,MG,MG,MG,MG,MG,MG,MG,MG,MG,MG,BK,YL,YL,YL,YL,YL,BK,BK,BK,YL,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,YL,BK,BK,BK,BK,YL,YL,YL,YL,BK,MG,MG,MG,MG,BK,BK,MG,MG,MG,MG,MG,BK,YL,YL,YL,YL,BK,BL,BL,BL,BK,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,MG,MG,MG,BK,TP,BK,MG,MG,MG,MG,BK,BK,YL,YL,YL,BK,BL,BL,BL,BL,BL,BK,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,MG,MG,MG,BK,TP,TP,BK,MG,MG,MG,MG,BK,TP,BK,YL,YL,BK,BL,BL,BL,BL,BL,BK,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,MG,MG,BK,TP,TP,TP,BK,MG,MG,MG,BK,TP,TP,BK,YL,YL,YL,BK,BL,BL,BL,BL,BK,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,MG,MG,BK,TP,TP,TP,TP,BK,MG,MG,MG,BK,TP,TP,TP,BK,YL,YL,YL,BK,BK,BK,BK,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,YL,YL,YL,BK,BK,BK,BK,MG,MG,BK,TP,TP,TP,TP,BK,BK,MG,MG,BK,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,TP,TP,TP,BK,BK,BK,TP,TP,TP,TP,TP,BK,MG,MG,BK,TP,TP,TP,TP,TP,TP,TP,BK,YL,YL,YL,YL,YL,YL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,MG,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,YL,YL,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* mechakawa chan */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,BK,BK,MG,MG,BK,ZN,ZN,BK,ZN,BK,BK,BK,WH,BK,BK,BK,BK,WH,BK,BK,ZN,ZN,BK,BK,BK,WH,WH,WH,BK,BK,BK,BK,BK,BK,MG,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,BK,MG,MG,MG,BK,ZN,ZN,BK,BK,WH,WH,BK,WH,BK,WH,BK,WH,WH,WH,BK,BK,BK,WH,BK,BK,BK,WH,BK,BK,WH,WH,BK,BK,BK,MG,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,BK,MG,MG,MG,BK,ZN,ZN,BK,BK,WH,WH,BK,BK,BK,BK,BK,BK,WH,BK,BK,ZN,BK,WH,WH,BK,BK,BK,BK,BK,WH,BK,BK,ZN,BK,MG,BK,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,BK,BK,MG,BK,ZN,ZN,ZN,BK,ZN,BK,BK,WH,BK,WH,BK,BK,WH,BK,ZN,ZN,ZN,ZN,BK,BK,WH,BK,BK,WH,BK,BK,BK,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,BK,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,BK,BK,BK,MG,MG,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,MG,MG,BK,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,MG,MG,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,MG,MG,BK,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,MG,MG,MG,BK,BK,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,MG,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,BK,MG,MG,MG,MG,BK,BK,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,MG,MG,MG,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,RD,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,BK,BK,MG,MG,BK,BK,BK,BK,BK,BK,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,BK,MG,MG,MG,MG,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,RD,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,BK,BK,BK,MG,MG,MG,MG,BK,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,BK,BK,BK,BK,MG,MG,BK,TP,TP,TP,TP,
  TP,TP,TP,BK,BK,BK,MG,BK,MG,BK,BK,BK,BK,TP,TP,TP,BK,BK,BK,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,BK,MG,BK,MG,BK,BK,TP,TP,TP,TP,TP,
  TP,TP,TP,BK,MG,MG,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,BK,MG,MG,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,BK,BK,MG,BK,BK,BK,MG,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,MG,BK,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,BK,BK,BK,BK,MG,MG,MG,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y5,Y5,Y5,Y5,Y5,Y5,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y5,Y5,Y5,Y5,Y5,Y5,Y5,Y5,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y5,Y5,Y5,Y5,Y5,Y5,Y5,Y5,Y5,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y5,Y5,Y5,Y5,Y5,Y5,Y5,Y5,Y5,Y5,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,Y5,Y5,Y5,Y5,Y5,Y5,Y5,Y5,BK,BK,Y5,Y5,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,Y5,Y5,BK,BK,Y5,Y5,Y5,Y5,Y5,BK,BK,BK,Y5,Y5,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,Y5,Y5,BK,BK,BK,Y5,Y5,Y5,Y5,Y5,BK,TP,TP,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,Y5,BK,BK,BK,TP,BK,Y5,Y5,Y5,Y5,Y5,BK,TP,TP,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,TP,TP,TP,BK,Y5,Y5,Y5,Y5,Y5,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,TP,TP,TP,TP,TP,BK,Y5,Y5,Y5,Y5,Y5,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,Y5,Y5,Y5,Y5,Y5,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y5,Y5,Y5,Y5,Y5,Y5,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y5,Y5,BK,BK,Y5,Y5,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y5,Y5,BK,BK,BK,Y5,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y5,Y5,BK,TP,BK,Y5,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y5,BK,BK,TP,BK,Y5,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y5,BK,TP,TP,TP,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,TP,TP,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* puniko chan */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZL,BK,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZL,ZL,BK,BK,BK,BK,YL,YL,YL,YL,YL,YL,YL,YL,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,ZL,ZL,ZL,BK,BK,BK,BK,TP,BK,BK,BK,BK,BK,ZL,ZL,ZL,BK,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,ZL,ZL,ZL,ZL,ZL,ZL,ZL,BK,BK,ZL,ZL,BK,ZL,ZL,BK,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,ZL,ZL,ZL,ZL,ZL,ZL,ZL,ZL,BK,ZL,ZL,BK,ZL,BK,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,BK,BK,ZL,ZL,ZL,ZL,ZL,ZL,ZL,BK,BK,ZL,BK,BK,BK,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,YL,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,ZL,ZL,ZL,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,BK,YL,YL,YL,YL,BK,BK,YL,YL,YL,YL,YL,YL,BK,YL,YL,YL,YL,YL,YL,BK,YL,YL,YL,YL,YL,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,ZL,BK,BK,BK,TP,TP,TP,BK,BK,BK,BK,ZN,ZN,BK,BK,BK,BK,BK,ZN,BK,BK,YL,YL,BK,BK,BK,BK,BK,YL,YL,YL,YL,BK,BK,BK,BK,YL,YL,BK,BK,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,ZN,ZN,ZN,ZN,BK,BK,YL,BK,BK,ZN,BK,BK,BK,BK,BK,BK,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,WH,BK,WH,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,WH,BK,BK,BK,BK,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,WH,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,WH,BK,BK,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,WH,BK,ZN,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,BK,WH,WH,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,RD,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,WH,WH,BK,BK,ZN,ZN,BK,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,RD,RD,RD,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,RD,RD,RD,RD,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,BK,BK,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,RD,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,RD,RD,RD,RD,RD,RD,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,GR,BK,GR,GR,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,GR,BK,GR,GR,BK,BK,GR,GR,GR,GR,GR,GR,GR,GR,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,GR,GR,BK,GR,GR,BK,GR,GR,GR,BK,GR,GR,BK,BK,GR,GR,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,GR,GR,BK,GR,GR,GR,BK,GR,GR,GR,BK,GR,GR,GR,BK,GR,GR,GR,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,GR,GR,BK,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,GR,BK,GR,GR,GR,GR,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,GR,GR,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,BK,BK,TP,TP,TP,TP,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,BK,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,BK,BK,TP,TP,TP,TP,BK,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,TP,TP,TP,TP,TP,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,

  /* punirin chan */
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,ZL,ZL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZL,ZL,ZL,ZL,ZL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZL,ZL,ZL,ZL,ZL,ZL,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,ZL,ZL,ZL,ZL,ZL,ZL,BK,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZL,ZL,ZL,ZL,ZL,ZL,ZL,BK,ZL,BK,ZL,ZL,ZL,ZL,BK,BK,BK,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZL,ZL,ZL,ZL,ZL,ZL,ZL,ZL,BK,ZL,BK,ZL,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZL,ZL,ZL,ZL,ZL,ZL,ZL,ZL,BK,ZL,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZL,ZL,ZL,ZL,ZL,ZL,ZL,ZL,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZL,ZL,ZL,ZL,ZL,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZL,ZL,ZL,ZL,ZL,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZL,ZL,ZL,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,ZN,ZN,ZN,ZN,BK,BK,BK,BK,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,ZN,BK,WH,BK,BK,ZN,ZN,ZN,BK,WH,BK,BK,BK,BK,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,WH,BK,ZN,ZN,BK,BK,BK,BK,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,ZN,ZN,BK,WH,BK,WH,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,WH,BK,BK,ZN,ZN,BK,BK,WH,BK,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,WH,BK,BK,ZN,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,RD,RD,BK,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,W0,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,BK,TP,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,BK,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,BK,BK,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,BK,BK,BK,BK,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,BK,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,Y7,Y7,Y7,Y7,Y7,Y7,Y7,Y7,BK,BK,BK,BK,MG,MG,MG,MG,BK,BK,MG,MG,MG,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,BK,MG,MG,MG,MG,BK,BK,MG,MG,BK,MG,MG,MG,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,MG,MG,MG,MG,MG,BK,MG,MG,MG,MG,BK,MG,MG,MG,BK,MG,MG,MG,BK,MG,MG,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,MG,MG,MG,MG,BK,MG,MG,MG,MG,MG,BK,MG,MG,MG,BK,MG,MG,MG,BK,MG,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,MG,MG,MG,MG,BK,MG,MG,MG,MG,MG,BK,MG,MG,MG,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,MG,MG,MG,MG,BK,MG,MG,MG,MG,MG,BK,BK,BK,BK,BK,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,MG,MG,MG,MG,BK,BK,BK,BK,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,BK,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,BK,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,ZN,ZN,ZN,ZN,ZN,ZN,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,BK,BK,BK,BK,BK,BK,BK,BK,BK,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
  TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,TP,
#endif
};

const struct charset charset_character = {
  CHARACTER_SIZE, CHARACTER_SIZE,
  sizeof(bitmap) / (sizeof(*bitmap) * CHARACTER_SIZE * CHARACTER_SIZE),
  bitmap, IMAGE_TYPE_ROUGHCOLOR, NLL_G_STATIC
};
#endif
