#ifndef __NLLIBC_UNISTD_H_INCLUDED__
#define __NLLIBC_UNISTD_H_INCLUDED__

#include <sys/types.h>

#define STDIN_FILENO  0
#define STDOUT_FILENO 1
#define STDERR_FILENO 2

#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2

void _exit(int status);
pid_t fork(void);
int execve(const char *path, char *const argv[], char *const envp[]);

ssize_t read(int fd, void *buf, size_t nbytes);
ssize_t write(int fd, const void *buf, size_t nbytes);
int close(int fd);

int dup(int oldd);
int pipe(int fildes[2]);
int dup2(int oldd, int newd);
int pipe2(int fildes[2], int flags);

pid_t getpid(void);
pid_t getppid(void);
pid_t getsid(pid_t pid);
pid_t setsid(void);
pid_t getpgid(pid_t pid);
int setpgid(pid_t pid, pid_t pgrp);
pid_t getpgrp(void);

pid_t tcgetpgrp(int fd);
int tcsetpgrp(int fd, pid_t pgrp_id);

int unlink(const char *path);
int chdir(const char *path);
int chdir(const char *path);
int fchdir(int fd);
int chown(const char *path, uid_t owner, gid_t group);
off_t lseek(int fildes, off_t offset, int whence);
int access(const char *path, int mode);
void sync(void);
int fsync(int fd);
int fchown(int fd, uid_t owner, gid_t group);

int truncate(const char *path, off_t length);
int ftruncate(int fd, off_t length);

#if defined(__linux__)
int brk(void *addr);
#else
int brk(const void *addr);
#endif
void *sbrk(intptr_t incr);

char *getcwd(char *buf, size_t size);

unsigned int sleep(unsigned int seconds);
int usleep(useconds_t microseconds);

int isatty(int fd);

#endif
