#ifndef __NLSYS_UNION_H_INCLUDED__
#define __NLSYS_UNION_H_INCLUDED__

typedef struct _union *union_t;

#include "type.h"
#include "objlist.h"
#include "syntax.h"
#include "area.h"

struct _union {
  struct objentry entry;
  char *name;
  int id;
  area_t members;
};

/*****************************************************************
 * union_t
 */

union_t union_destroy(union_t _union);
union_t union_create(char *name);
void union_print(union_t _union, int indent);

/*****************************************************************
 * library
 */

union_t union_list_search(objlist_t list, char *name);
int union_normalize(syntax_t syntax, objlist_t syntax_list,
		    objlist_t defines_list);

#endif
