#ifndef __NLSYS_STRUCT_H_INCLUDED__
#define __NLSYS_STRUCT_H_INCLUDED__

typedef struct _struct *struct_t;

#include "type.h"
#include "objlist.h"
#include "syntax.h"
#include "area.h"

struct _struct {
  struct objentry entry;
  char *name;
  int id;
  area_t members;
};

/*****************************************************************
 * struct_t
 */

struct_t struct_destroy(struct_t _struct);
struct_t struct_create(char *name);
void struct_print(struct_t _struct, int indent);

/*****************************************************************
 * library
 */

struct_t struct_list_search(objlist_t list, char *name);
int struct_normalize(syntax_t syntax, objlist_t syntax_list,
		     objlist_t defines_list);

#endif
