#ifndef __NLSYS_ASM_QUEUE_H_INCLUDED__
#define __NLSYS_ASM_QUEUE_H_INCLUDED__

#include "type.h"
#include "model.h"

/* asm_format_* */

void asm_queue_format_comment(FILE *out, char *comment, char *param1, char *param2, char *param3);
void asm_queue_format_newline(FILE *out);
void asm_queue_format_align(FILE *out, int size);
void asm_queue_format_space(FILE *out, int size);
void asm_queue_format_label(FILE *out, char *label);
void asm_queue_format_globl(FILE *out, char *name);
void asm_queue_format_type(FILE *out, char *name, char *prefix, asm_format_type_t type);
void asm_queue_format_size(FILE *out, char *name, int size);
void asm_queue_format_dummy(FILE *out);
void asm_queue_format_string(FILE *out, char *string, int size);
void asm_queue_format_value(FILE *out, asm_format_type_t type, long number, char *name);
void asm_queue_format_section(FILE *out, asm_format_type_t type);

/* asm_code_* */

void asm_queue_code_get_value(FILE *out, long value);
void asm_queue_code_get_value_r1(FILE *out, long value);
void asm_queue_code_get_address_stack(FILE *out, int offset);
int asm_queue_code_get_address_stack_r1(FILE *out, int offset);
void asm_queue_code_get_address(FILE *out, char *label);
void asm_queue_code_add_address(FILE *out, int offset);
void asm_queue_code_get_r1(FILE *out);
void asm_queue_code_set_r1(FILE *out);
void asm_queue_code_memory_load(FILE *out, int offset, model_t model);
void asm_queue_code_memory_store(FILE *out, int offset, model_t model);
void asm_queue_code_stack_load(FILE *out, int offset, model_t model);
void asm_queue_code_stack_store(FILE *out, int offset, model_t model);
void asm_queue_code_stack_load_r1(FILE *out, int offset, model_t model);
void asm_queue_code_stack_store_r1(FILE *out, int offset, model_t model);
void asm_queue_code_stack_expand(FILE *out, int size);
void asm_queue_code_stack_reduce(FILE *out, int size);
void asm_queue_code_funccall_reg_load(FILE *out, int number);
void asm_queue_code_funccall_reg_store(FILE *out, int number);
void asm_queue_code_tmp_reg_load(FILE *out, int number);
void asm_queue_code_tmp_reg_save(FILE *out, int number);
void asm_queue_code_tmp_reg_load_r1(FILE *out, int number);
void asm_queue_code_tmp_reg_save_r1(FILE *out, int number);
int asm_queue_code_sign_extension_char(FILE *out);
int asm_queue_code_sign_extension_uchar(FILE *out);
int asm_queue_code_sign_extension_short(FILE *out);
int asm_queue_code_sign_extension_ushort(FILE *out);
int asm_queue_code_sign_extension_int(FILE *out);
int asm_queue_code_sign_extension_uint(FILE *out);
int asm_queue_code_calc_inv(FILE *out, model_t model, model_t model_arg0);
int asm_queue_code_calc_minus(FILE *out, model_t model, model_t model_arg0);
int asm_queue_code_calc_op1(FILE *out, c_type_t type, model_t model, model_t model_arg0);
void asm_queue_code_calc_add(FILE *out, model_t model, model_t model_arg0, model_t model_arg1);
void asm_queue_code_calc_sub(FILE *out, model_t model, model_t model_arg0, model_t model_arg1);
void asm_queue_code_calc_and(FILE *out, model_t model, model_t model_arg0, model_t model_arg1);
void asm_queue_code_calc_or(FILE *out, model_t model, model_t model_arg0, model_t model_arg1);
int asm_queue_code_calc_xor(FILE *out, model_t model, model_t model_arg0, model_t model_arg1);
int asm_queue_code_calc_mul(FILE *out, model_t model, model_t model_arg0, model_t model_arg1);
int asm_queue_code_calc_div(FILE *out, model_t model, model_t model_arg0, model_t model_arg1);
int asm_queue_code_calc_mod(FILE *out, model_t model, model_t model_arg0, model_t model_arg1);
int asm_queue_code_calc_llshift(FILE *out, model_t model, model_t model_arg0, model_t model_arg1);
int asm_queue_code_calc_rashift(FILE *out, model_t model, model_t model_arg0, model_t model_arg1);
int asm_queue_code_calc_rlshift(FILE *out, model_t model, model_t model_arg0, model_t model_arg1);
int asm_queue_code_calc_op2(FILE *out, c_type_t type, model_t model, model_t model_arg0, model_t model_arg1);
void asm_queue_code_branch(FILE *out, char *label);
int asm_queue_code_branch_zero(FILE *out, char *label);
int asm_queue_code_branch_nzero(FILE *out, char *label);
int asm_queue_code_branch_cmp_eq(FILE *out, char *label, model_t model);
int asm_queue_code_branch_cmp_ne(FILE *out, char *label, model_t model);
int asm_queue_code_branch_cmp_lt(FILE *out, char *label, model_t model);
int asm_queue_code_branch_cmp_gt(FILE *out, char *label, model_t model);
int asm_queue_code_branch_cmp_le(FILE *out, char *label, model_t model);
int asm_queue_code_branch_cmp_ge(FILE *out, char *label, model_t model);
int asm_queue_code_branch_cmp_ult(FILE *out, char *label, model_t model);
int asm_queue_code_branch_cmp_ugt(FILE *out, char *label, model_t model);
int asm_queue_code_branch_cmp_ule(FILE *out, char *label, model_t model);
int asm_queue_code_branch_cmp_uge(FILE *out, char *label, model_t model);
int asm_queue_code_branch_cmp(FILE *out, char *label, c_type_t type, model_t model);
int asm_queue_code_function_call(FILE *out, char *label);
int asm_queue_code_function_call_set(FILE *out);
int asm_queue_code_function_call_pointer(FILE *out);
void asm_queue_code_function_start(FILE *out);
void asm_queue_code_function_end(FILE *out);
void asm_queue_code_function_register_save(FILE *out);
void asm_queue_code_function_register_load(FILE *out);

/* asm queue service */

int asm_queue_set_level(int level);
int asm_queue_flush(void);

#endif
