#ifndef __NLLIBC_LIB_H_INCLUDED__
#define __NLLIBC_LIB_H_INCLUDED__

int32_t __ashlsi3(int32_t val, int s); /* 32bit left shift arithmetic */
uint32_t __lshlsi3(uint32_t val, int s); /* 32bit left shift logical */
int32_t __ashrsi3(int32_t val, int s); /* 32bit right shift arithmetic */
uint32_t __lshrsi3(uint32_t val, int s); /* 32bit right shift logical */
int64_t __ashldi3(int64_t val, int s); /* 64bit left shift arithmetic */
uint64_t __lshldi3(uint64_t val, int s); /* 64bit left shift logical */
int64_t __ashrdi3(int64_t val, int s); /* 64bit right shift arithmetic */
uint64_t __lshrdi3(uint64_t val, int s); /* 64bit right shift logical */

int32_t __divsi3(int32_t val, int32_t div);
int32_t __modsi3(int32_t val, int32_t div);
uint32_t __udivsi3(uint32_t val, uint32_t div);
uint32_t __umodsi3(uint32_t val, uint32_t div);
int64_t __divdi3(int64_t val, int64_t div);
int64_t __moddi3(int64_t val, int64_t div);
uint64_t __udivdi3(uint64_t val, uint64_t div);
uint64_t __umoddi3(uint64_t val, uint64_t div);

int32_t __mulsi3(int32_t val,  int32_t mul);
uint32_t __umulsi3(uint32_t val, uint32_t mul);
int64_t __muldi3(int64_t val, int64_t mul);
uint64_t __umuldi3(uint64_t val, uint64_t mul);

#endif
