#if defined(__linux__)
#if defined(__hppa__)

/*
 * Use Linux system call.
 */

#define SYS_exit          1
#define SYS_fork          2
#define SYS_wait4       114
#define SYS_kill         37
#define SYS_execve       11

#define SYS_read          3
#define SYS_write         4
#define SYS_open          5
#define SYS_close         6

#define SYS_dup          41
#define SYS_pipe         42
#define SYS_dup2         63
#define SYS_pipe2       313

#define SYS_sigaction   174 /* rt_sigaction */
#define SYS_sigprocmask 175 /* rt_sigprocmask */
#define SYS_sigreturn   173 /* rt_sigreturn */

#define SYS_getpid       20
#define SYS_getppid      64
#define SYS_getsid      147
#define SYS_setsid       66
#define SYS_getpgid     132
#define SYS_setpgid      57
#define SYS_getpgrp      65

#define SYS_unlink       10
#define SYS_chdir        12
#define SYS_fchdir      133
#define SYS_chmod        15
#define SYS_chown       180
#define SYS_lseek        19
#define SYS_access       33
#define SYS_sync         36
#define SYS_fcntl        55
#define SYS_fsync       118
#define SYS_fchown       95
#define SYS_fchmod       94
#define SYS_rename       38

#define SYS_mkdir        39
#define SYS_rmdir        40

#define SYS_mmap         90
#define SYS_munmap       91

#define SYS_truncate     92
#define SYS_ftruncate    93

#define SYS_select      142 /* newselect */
#define SYS_pselect     273

#define SYS_gettimeofday 78
#define SYS_settimeofday 79

#define SYS_ioctl        54
#define SYS_brk          45
#define SYS_getdents    141
#define SYS_getcwd      110

	.section .text

	.globl	___exit
	.type	___exit, @function
___exit:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_exit, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__fork
	.type	__fork, @function
__fork:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_fork, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__wait4
	.type	__wait4, @function
__wait4:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_wait4, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__kill
	.type	__kill, @function
__kill:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_kill, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__execve
	.type	__execve, @function
__execve:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_execve, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__read
	.type	__read, @function
__read:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_read, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__write
	.type	__write, @function
__write:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_write, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__open
	.type	__open, @function
__open:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_open, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__close
	.type	__close, @function
__close:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_close, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__dup
	.type	__dup, @function
__dup:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_dup, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__pipe
	.type	__pipe, @function
__pipe:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_pipe, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__dup2
	.type	__dup2, @function
__dup2:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_dup2, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__pipe2
	.type	__pipe2, @function
__pipe2:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_pipe2, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__sigaction
	.type	__sigaction, @function
__sigaction:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_sigaction, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__sigprocmask
	.type	__sigprocmask, @function
__sigprocmask:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_sigprocmask, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__sigreturn
	.type	__sigreturn, @function
__sigreturn:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_sigreturn, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__getpid
	.type	__getpid, @function
__getpid:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_getpid, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__getppid
	.type	__getppid, @function
__getppid:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_getppid, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__getsid
	.type	__getsid, @function
__getsid:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_getsid, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__setsid
	.type	__setsid, @function
__setsid:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_setsid, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__getpgid
	.type	__getpgid, @function
__getpgid:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_getpgid, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__setpgid
	.type	__setpgid, @function
__setpgid:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_setpgid, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__getpgrp
	.type	__getpgrp, @function
__getpgrp:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_getpgrp, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__unlink
	.type	__unlink, @function
__unlink:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_unlink, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__chdir
	.type	__chdir, @function
__chdir:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_chdir, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__fchdir
	.type	__fchdir, @function
__fchdir:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_fchdir, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__chmod
	.type	__chmod, @function
__chmod:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_chmod, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__chown
	.type	__chown, @function
__chown:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_chown, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__lseek
	.type	__lseek, @function
__lseek:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_lseek, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__access
	.type	__access, @function
__access:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_access, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__sync
	.type	__sync, @function
__sync:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_sync, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__fcntl
	.type	__fcntl, @function
__fcntl:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_fcntl, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__fsync
	.type	__fsync, @function
__fsync:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_fsync, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__fchown
	.type	__fchown, @function
__fchown:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_fchown, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__fchmod
	.type	__fchmod, @function
__fchmod:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_fchmod, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__rename
	.type	__rename, @function
__rename:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_rename, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__mkdir
	.type	__mkdir, @function
__mkdir:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_mkdir, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__rmdir
	.type	__rmdir, @function
__rmdir:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_rmdir, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__mmap
	.type	__mmap, @function
__mmap:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_mmap, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__munmap
	.type	__munmap, @function
__munmap:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_munmap, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__truncate
	.type	__truncate, @function
__truncate:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_truncate, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__ftruncate
	.type	__ftruncate, @function
__ftruncate:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_ftruncate, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__select
	.type	__select, @function
__select:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_select, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__pselect
	.type	__pselect, @function
__pselect:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_pselect, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__gettimeofday
	.type	__gettimeofday, @function
__gettimeofday:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_gettimeofday, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__settimeofday
	.type	__settimeofday, @function
__settimeofday:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_settimeofday, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__ioctl
	.type	__ioctl, @function
__ioctl:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_ioctl, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__brk
	.type	__brk, @function
__brk:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_brk, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	__getdents
	.type	__getdents, @function
__getdents:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_getdents, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop

	.globl	____getcwd
	.type	____getcwd, @function
____getcwd:
	copy	%r19, %r4
	ble	0x100(%sr2, %r28)
	ldi	SYS_getcwd, %r20
	copy	%r4, %r19
	bv	%r0(%rp)
	nop
#endif
#endif
