#ifndef __NLLIBC_DIRENT_H_INCLUDED__
#define __NLLIBC_DIRENT_H_INCLUDED__

#include <sys/types.h>

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__DragonFly__) || defined(__APPLE__)
struct dirent {
  uint32_t d_fileno;
  uint16_t d_reclen;
  uint8_t d_type;
  uint8_t d_namlen;
#define MAXNAMLEN 255
  char d_name[MAXNAMLEN + 1];
};

#define DT_UNKNOWN  0
#define DT_DIR      4
#define DT_REG      8
#define DT_LNK     10

ssize_t getdents(int fd, char *buf, size_t nbytes);
#endif

#if defined(__linux__)
struct dirent {
  unsigned long d_fileno;
  unsigned long d_off;
  unsigned short d_reclen;
  unsigned char d_type;
#define MAXNAMLEN 255
  char d_name[MAXNAMLEN + 1];
};

#define DT_UNKNOWN  0
#define DT_DIR      4
#define DT_REG      8
#define DT_LNK     10

int getdents(int fd, char *buf, int nbytes);
#endif

#ifdef WIN32
struct dirent {
  uint32_t d_fileno;
  uint16_t d_reclen;
  uint16_t d_namlen;
  uint32_t d_type;
  int64_t d_time_create; /* time_t */
  int64_t d_time_access; /* time_t */
  int64_t d_time_write;  /* time_t */
  uint32_t d_size;
#define FILENAME_MAX 260
#define MAXNAMLEN (FILENAME_MAX - 1)
  char d_name[MAXNAMLEN + 1];
};

#define DT_UNKNOWN  0x18
#define DT_DIR      0x10
#define DT_REG      0x00
#define DT_LNK     0x818

ssize_t getdents(int fd, char *buf, size_t nbytes);
#endif

typedef struct _dirdesc DIR;

DIR *opendir(const char *filename);
DIR *fdopendir(int fd);
struct dirent *readdir(DIR *dirp);
int closedir(DIR *dirp);
int fdclosedir(DIR *dirp);
int dirfd(DIR *dirp);

#endif
