#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef USE_NLLIBC
#include <nllibc.h>
#endif

#include "mouse.h"

static const struct {
  mouse_code_t code;
  const char *name;
} mouses[] = {
  { MOUSE_CODE_RIGHT , MOUSE_NAME_RIGHT  },
  { MOUSE_CODE_LEFT  , MOUSE_NAME_LEFT   },
  { MOUSE_CODE_MIDDLE, MOUSE_NAME_MIDDLE },

  { MOUSE_CODE_NONE  , NULL              },
};

const char *mousename_get(mouse_code_t code)
{
  int i;

  for (i = 0; mouses[i].name; i++) {
    if (code == mouses[i].code)
      return mouses[i].name;
  }

  return NULL;
}

mouse_code_t mousecode_get(const char *name)
{
  int i;

  if (!name)
    return MOUSE_CODE_NONE;

  for (i = 0; mouses[i].name; i++) {
    if (!strcmp(name, mouses[i].name))
      return mouses[i].code;
  }

  return MOUSE_CODE_NONE;
}
