#ifndef __NLL_FUNCTION_H_INCLUDED__
#define __NLL_FUNCTION_H_INCLUDED__

enum {
  FUNCTION_TYPE_NONE = 0,
  FUNCTION_TYPE_FARGS,
  FUNCTION_TYPE_COPY,
  FUNCTION_TYPE_TRUE,
  FUNCTION_TYPE_FALSE,
  FUNCTION_TYPE_ARGNUM,
  FUNCTION_TYPE_BOOLEAN,
  FUNCTION_TYPE_COND,
  FUNCTION_TYPE_AT,
  FUNCTION_TYPE_FPUSH,
  FUNCTION_TYPE_FPOP,
  FUNCTION_TYPE_STACKNUM,
  FUNCTION_TYPE_FPRINT,
  FUNCTION_TYPE_SPRINTF,
  FUNCTION_TYPE_PRINTF,
  FUNCTION_TYPE_PRINTM,
  FUNCTION_TYPE_INPUT,
  FUNCTION_TYPE_INPUTN,
  FUNCTION_TYPE_FWAIT,
  FUNCTION_TYPE_TIMER,
  FUNCTION_TYPE_NOSYSTEM,
  FUNCTION_TYPE_NOSYSCALL,
  FUNCTION_TYPE_NONETWORK,
#ifdef NLL_STDIO_FUNCTION
  FUNCTION_TYPE_FSTDIN,
  FUNCTION_TYPE_FSTDOUT,
#endif
#ifdef NLL_SYSTEM_FUNCTION
  FUNCTION_TYPE_SYSTEM,
#endif
#ifdef NLL_SYSCALL_FUNCTION
  FUNCTION_TYPE_SYSCALL,
#endif
  FUNCTION_TYPE_FEVAL,
  FUNCTION_TYPE_FEVALF,
  FUNCTION_TYPE_TYPEOF,
  FUNCTION_TYPE_TYPENAME,
  FUNCTION_TYPE_SIZEOF,
  FUNCTION_TYPE_NZERO,
  FUNCTION_TYPE_CMP,
  FUNCTION_TYPE_REP,
  FUNCTION_TYPE_INSERT,
  FUNCTION_TYPE_DELETE,
  FUNCTION_TYPE_ITOC,
  FUNCTION_TYPE_CTOI,
  FUNCTION_TYPE_ITOA,
  FUNCTION_TYPE_ATOI,
#ifdef NLL_FLOATING_POINT
  FUNCTION_TYPE_ITOF,
  FUNCTION_TYPE_FTOI,
  FUNCTION_TYPE_ATOF,
  FUNCTION_TYPE_FTOA,
#endif
  FUNCTION_TYPE_ISALNUM,
  FUNCTION_TYPE_ISALPHA,
  FUNCTION_TYPE_ISASCII,
  FUNCTION_TYPE_ISCNTRL,
  FUNCTION_TYPE_ISDIGIT,
  FUNCTION_TYPE_ISGRAPH,
  FUNCTION_TYPE_ISLOWER,
  FUNCTION_TYPE_ISPRINT,
  FUNCTION_TYPE_ISPUNCT,
  FUNCTION_TYPE_ISSPACE,
  FUNCTION_TYPE_ISUPPER,
  FUNCTION_TYPE_ISXDIGIT,
  FUNCTION_TYPE_TOLOWER,
  FUNCTION_TYPE_TOUPPER,
  FUNCTION_TYPE_LEFT,
  FUNCTION_TYPE_RIGHT,
  FUNCTION_TYPE_MID,
  FUNCTION_TYPE_INSTR,
  FUNCTION_TYPE_STRLEN,
  FUNCTION_TYPE_STRCPY,
  FUNCTION_TYPE_SPLIT,
  FUNCTION_TYPE_SPLITS,
  FUNCTION_TYPE_CHOMP,
  FUNCTION_TYPE_LCHOMP,
  FUNCTION_TYPE_RCHOMP,
  FUNCTION_TYPE_SRAND,
  FUNCTION_TYPE_RAND,
  FUNCTION_TYPE_INT,
  FUNCTION_TYPE_ABS,
  FUNCTION_TYPE_SIGN,
  FUNCTION_TYPE_MAX,
  FUNCTION_TYPE_MIN,
  FUNCTION_TYPE_ABS2SUM,
  FUNCTION_TYPE_TIME,
  FUNCTION_TYPE_DATE,
  FUNCTION_TYPE_FDIM,
  FUNCTION_TYPE_FMEMORY,
  FUNCTION_TYPE_PEEK,
  FUNCTION_TYPE_POKE,
  FUNCTION_TYPE_MREAD,
  FUNCTION_TYPE_MWRITE,
  FUNCTION_TYPE_MCOPY,
#ifdef USE_MATHLIB
  FUNCTION_TYPE_PI,
  FUNCTION_TYPE_RADIAN,
  FUNCTION_TYPE_DEGREE,
  FUNCTION_TYPE_SIN,
  FUNCTION_TYPE_COS,
  FUNCTION_TYPE_TAN,
  FUNCTION_TYPE_ASIN,
  FUNCTION_TYPE_ACOS,
  FUNCTION_TYPE_ATAN,
  FUNCTION_TYPE_SINH,
  FUNCTION_TYPE_COSH,
  FUNCTION_TYPE_TANH,
  FUNCTION_TYPE_EXP,
  FUNCTION_TYPE_LOG,
  FUNCTION_TYPE_LOG10,
  FUNCTION_TYPE_SQRT,
  FUNCTION_TYPE_ATAN2,
  FUNCTION_TYPE_POW,
  FUNCTION_TYPE_FMOD,
  FUNCTION_TYPE_INFINITY,
  FUNCTION_TYPE_NAN,
  FUNCTION_TYPE_ISFINITE,
  FUNCTION_TYPE_ISINF,
  FUNCTION_TYPE_ISNAN,
  FUNCTION_TYPE_ISNORMAL,
#endif
  FUNCTION_TYPE_RENAME,
  FUNCTION_TYPE_UNLINK,
  FUNCTION_TYPE_TRUNCATE,
  FUNCTION_TYPE_MKDIR,
  FUNCTION_TYPE_RMDIR,
  FUNCTION_TYPE_CHDIR,
  FUNCTION_TYPE_OPEN,
  FUNCTION_TYPE_CLOSE,
  FUNCTION_TYPE_READ,
  FUNCTION_TYPE_WRITE,
  FUNCTION_TYPE_LSEEK,
  FUNCTION_TYPE_FTRUNCATE,
  FUNCTION_TYPE_ISREADABLE,
  FUNCTION_TYPE_ISWRITABLE,
  FUNCTION_TYPE_FOPEN,
  FUNCTION_TYPE_FDOPEN,
  FUNCTION_TYPE_FCLOSE,
  FUNCTION_TYPE_FILENO,
  FUNCTION_TYPE_FEOF,
  FUNCTION_TYPE_FERROR,
  FUNCTION_TYPE_FGETC,
  FUNCTION_TYPE_FPUTC,
  FUNCTION_TYPE_FGETS,
  FUNCTION_TYPE_FPUTS,
  FUNCTION_TYPE_FPRINTF,
  FUNCTION_TYPE_FREAD,
  FUNCTION_TYPE_FWRITE,
  FUNCTION_TYPE_FSEEK,
  FUNCTION_TYPE_QOPEN,
  FUNCTION_TYPE_QCLOSE,
  FUNCTION_TYPE_QLENGTH,
  FUNCTION_TYPE_QPUSHF,
  FUNCTION_TYPE_QPOPL,
  FUNCTION_TYPE_QPUSHL,
  FUNCTION_TYPE_QPOPF,
#ifdef NLL_NETWORK_FUNCTION
  FUNCTION_TYPE_SOCKADDR,
  FUNCTION_TYPE_SOCKET,
  FUNCTION_TYPE_BIND,
  FUNCTION_TYPE_LISTEN,
  FUNCTION_TYPE_ACCEPT,
  FUNCTION_TYPE_CONNECT,
  FUNCTION_TYPE_SHUTDOWN,
  FUNCTION_TYPE_RECV,
  FUNCTION_TYPE_SEND,
  FUNCTION_TYPE_RECVFROM,
  FUNCTION_TYPE_SENDTO,
#endif
  FUNCTION_TYPE_KEYNAME,
  FUNCTION_TYPE_KEYCODE,
  FUNCTION_TYPE_SCREEN,
  FUNCTION_TYPE_SCRSTAT,
  FUNCTION_TYPE_FLUSH,
  FUNCTION_TYPE_GETCOLOR,
  FUNCTION_TYPE_GETFGCOLOR,
  FUNCTION_TYPE_GETBGCOLOR,
  FUNCTION_TYPE_SETCOLOR,
  FUNCTION_TYPE_GETATTR,
  FUNCTION_TYPE_SETATTR,
  FUNCTION_TYPE_GETPOS,
  FUNCTION_TYPE_MOVE,
  FUNCTION_TYPE_GETCH,
  FUNCTION_TYPE_CLEAR,
  FUNCTION_TYPE_SCROLL,
  FUNCTION_TYPE_LINE,
  FUNCTION_TYPE_BOX,
  FUNCTION_TYPE_INKEY,
  FUNCTION_TYPE_GSCREEN,
  FUNCTION_TYPE_GSCRSTAT,
  FUNCTION_TYPE_GCOLOR,
  FUNCTION_TYPE_GRGB,
  FUNCTION_TYPE_GSYNC,
  FUNCTION_TYPE_GFLUSH,
  FUNCTION_TYPE_GGETMAINIMG,
  FUNCTION_TYPE_GSETMAINIMG,
  FUNCTION_TYPE_GGETSIZE,
  FUNCTION_TYPE_GGETRANGE,
  FUNCTION_TYPE_GSETRANGE,
  FUNCTION_TYPE_GGETOFFSET,
  FUNCTION_TYPE_GSETOFFSET,
  FUNCTION_TYPE_GGETSCALE,
  FUNCTION_TYPE_GSETSCALE,
  FUNCTION_TYPE_GGETDOTOFFSET,
  FUNCTION_TYPE_GSETDOTOFFSET,
  FUNCTION_TYPE_GGETDOTSIZE,
  FUNCTION_TYPE_GSETDOTSIZE,
  FUNCTION_TYPE_GGETCOLOR,
  FUNCTION_TYPE_GSETCOLOR,
  FUNCTION_TYPE_GGETPIXEL,
  FUNCTION_TYPE_GCLEAR,
  FUNCTION_TYPE_GSCROLL,
  FUNCTION_TYPE_GDOT,
  FUNCTION_TYPE_GLINE,
  FUNCTION_TYPE_GBOX,
  FUNCTION_TYPE_GCIRCLE,
  FUNCTION_TYPE_GPAINT,
  FUNCTION_TYPE_GCOPY,
  FUNCTION_TYPE_GROTATE,
  FUNCTION_TYPE_GCHAR,
  FUNCTION_TYPE_GPRINT,
  FUNCTION_TYPE_GINKEY,
  FUNCTION_TYPE_GKEYSTAT,
  FUNCTION_TYPE_GMOUSEPOS,
  FUNCTION_TYPE_GINMOUSE,
  FUNCTION_TYPE_GMOUSESTAT,
  FUNCTION_TYPE_GALLOCIMAGE,
  FUNCTION_TYPE_GFREEIMAGE,
  FUNCTION_TYPE_GLOADIMAGE,
  FUNCTION_TYPE_GSAVEIMAGE,
  FUNCTION_TYPE_GCMPIMAGE,
  FUNCTION_TYPE_GCHARSET,
  FUNCTION_TYPE_ASTOP,
  FUNCTION_TYPE_ACLEAR,
  FUNCTION_TYPE_ASOUND,
  FUNCTION_TYPE_ASNDSTAT,
  FUNCTION_TYPE_APLAYNUM,
  FUNCTION_TYPE_AWAIT,
  FUNCTION_TYPE_AUNITSET,
  FUNCTION_TYPE_AUNIT,
  FUNCTION_TYPE_AOSC,
  FUNCTION_TYPE_AADDOUT,
  FUNCTION_TYPE_AENVPOINT,
  FUNCTION_TYPE_AENVCOPY,
  FUNCTION_TYPE_AFILPOINT,
  FUNCTION_TYPE_AFILCOPY,
  FUNCTION_TYPE_APLAY,
  FUNCTION_TYPE_AOPEN,
  FUNCTION_TYPE_ACLOSE,
};

const char *function_name(function_t function);
int function_search(const char *name, function_t *functionp);
int function_list(FILE *fp);
int function_proc(function_t function, value_t *valuep, value_t args);

#endif
