#ifndef __NLSYS_VALUE_H_INCLUDED__
#define __NLSYS_VALUE_H_INCLUDED__

typedef struct _value *value_t;

#include "type.h"
#include "objlist.h"
#include "syntax.h"
#include "area.h"

#define VALUE_ARG_NUM 3
#define VALUE_FUNCTION_ARGS_NUM 16

struct _value {
  /*
   * NUMBER, STRING, ARRAY, VARIABLE, FUNCTION,
   * or operator (PLUS, MINUS, ...)
   */
  c_type_t type;

  union {
    long number;
    struct {
      int size;
      char *s;
    } string;
    struct {
      int number;
      objlist_t values;
    } array;
    struct {
      symbol_t symbol;
    } label;
    struct {
      symbol_t symbol;
    } variable;
    struct {
      symbol_t symbol;
      struct {
	int number;
	symbol_t arg[VALUE_FUNCTION_ARGS_NUM];
      } args;
    } function;
    struct {
      int number;
    } arg;
    struct {
      syntax_t syntax;
    } block;
    struct {
      symbol_t arg[VALUE_ARG_NUM];
    } op;
  } obj;
};

/*****************************************************************
 * value_t
 */

value_t value_destroy(value_t value);
value_t value_create(c_type_t type);
void value_print_simple(value_t value, int indent);
void value_print(value_t value, int indent);
void value_print_args(value_t value, int indent);

/*****************************************************************
 * library
 */

symbol_t value_make_op1(c_type_t type, symbol_t arg0,
			objlist_t defines_list, objlist_t symbols,
			area_t static_area, area_t stack_area);
symbol_t value_make_op2(c_type_t type, symbol_t arg0, symbol_t arg1,
			objlist_t defines_list, objlist_t symbols,
			area_t static_area, area_t stack_area);

symbol_t value_read(objlist_t words,
		    objlist_t defines_list, objlist_t symbols,
		    area_t static_area, area_t stack_area,
		    objentry_search_func_t search_func, int arg, void *argp,
		    int permit_noterm, int keep_term);

#endif
