void printcx(char val);
void printix(int val);

union sample {
  unsigned char c[4];
  unsigned short s[2];
  unsigned int i;
};

unsigned int read_int_be(union sample *u)
{
  unsigned int val;
  val  = u->c[0] << 24;
  val |= u->c[1] << 16;
  val |= u->c[2] <<  8;
  val |= u->c[3];
  return val;
}

unsigned int write_int_be(union sample *u, unsigned int val)
{
  u->c[0] = val >> 24;
  u->c[1] = val >> 16;
  u->c[2] = val >>  8;
  u->c[3] = val;
  return u->i;
}

int main()
{
  union sample s;
  unsigned int val;

  write_int_be(&s, 0x12345678);
  printcx(s.c[0]);
  printcx(s.c[1]);
  printcx(s.c[2]);
  printcx(s.c[3]);

  val = read_int_be(&s);
  printix(val);

  return 0;
}
