#include <signal.h>
#include <errno.h>
#include <sys/types.h>

#include <nllibc.h>

int _set_errno(int retval);

int killpg(pid_t pgrp, int sig)
{
  if (pgrp == 1) {
    errno = ESRCH;
    return -1;
  }
  if (pgrp < 0) { 
    errno = EINVAL;
    return -1;
  }
  return kill(-pgrp, sig);
}
